﻿namespace MathML

    module OperatorDictionary =

        let acuteAccentPostfix =            
             {character = Unicode 0xB4;  
              glyph = "´";  
              name="acute accent";  
              priority = 880;  
              form = Postfix;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]} 
        let acuteAngleInfix = 
             {character = Unicode 0x299F;  
              glyph = "⦟";  
              name="acute angle";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let allEqualToInfix = 
             {character = Unicode 0x224C;  
              glyph = "≌";  
              name="all equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let almostEqualOrEqualToInfix = 
             {character = Unicode 0x224A;  
              glyph = "≊";  
              name="almost equal or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let almostEqualToInfix = 
             {character = Unicode 0x2248;  
              glyph = "≈";  
              name="almost equal to";  
              form = Infix;  
              priority = 247;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let almostEqualToWithCircumflexAccentInfix = 
             {character = Unicode 0x2A6F;  
              glyph = "⩯";  
              name="almost equal to with circumflex accent";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let amalgamationOrCoproductInfix = 
             {character = Unicode 0x2A3F;  
              glyph = "⨿";  
              name="amalgamation or coproduct";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let ampersandPostfix = 
             {character = Char '&';  
              glyph = "&";  
              name="ampersand";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let anglePrefix = 
             {character = Unicode 0x2220;  
              glyph = "∠";  
              name="angle";  
              form = Prefix;  
              priority = 670;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let angleWithSInsideInfix = 
             {character = Unicode 0x299E;  
              glyph = "⦞";  
              name="angle with s inside";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let angleWithUnderbarInfix = 
             {character = Unicode 0x29A4;  
              glyph = "⦤";  
              name="angle with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let anticlockwiseClosedCircleArrowInfix = 
             {character = Unicode 0x2940;  
              glyph = "⥀";  
              name="anticlockwise closed circle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let anticlockwiseContourIntegralPrefix = 
             {character = Unicode 0x2233;  
              glyph = "∳";  
              name="anticlockwise contour integral";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let anticlockwiseIntegrationPrefix = 
             {character = Unicode 0x2A11;  
              glyph = "⨑";  
              name="anticlockwise integration";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let anticlockwiseOpenCircleArrowInfix = 
             {character = Unicode 0x21BA;  
              glyph = "↺";  
              name="anticlockwise open circle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let anticlockwiseTopSemicircleArrowInfix = 
             {character = Unicode 0x21B6;  
              glyph = "↶";  
              name="anticlockwise top semicircle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let apostrophePostfix = 
             {character = Char ''';  
              glyph = "'";  
              name="apostrophe";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let approachesTheLimitInfix = 
             {character = Unicode 0x2250;  
              glyph = "≐";  
              name="approaches the limit";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let approximatelyButNotActuallyEqualToInfix = 
             {character = Unicode 0x2246;  
              glyph = "≆";  
              name="approximately but not actually equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let approximatelyEqualOrEqualToInfix = 
             {character = Unicode 0x2A70;  
              glyph = "⩰";  
              name="approximately equal or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let approximatelyEqualToInfix = 
             {character = Unicode 0x2245;  
              glyph = "≅";  
              name="approximately equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let approximatelyEqualToOrTheImageOfInfix = 
             {character = Unicode 0x2252;  
              glyph = "≒";  
              name="approximately equal to or the image of";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let arrowPointingDownwardsThenCurvingLeftwardsInfix = 
             {character = Unicode 0x2936;  
              glyph = "⤶";  
              name="arrow pointing downwards then curving leftwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let arrowPointingDownwardsThenCurvingRightwardsInfix = 
             {character = Unicode 0x2937;  
              glyph = "⤷";  
              name="arrow pointing downwards then curving rightwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let arrowPointingRightwardsThenCurvingDownwardsInfix = 
             {character = Unicode 0x2935;  
              glyph = "⤵";  
              name="arrow pointing rightwards then curving downwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let arrowPointingRightwardsThenCurvingUpwardsInfix = 
             {character = Unicode 0x2934;  
              glyph = "⤴";  
              name="arrow pointing rightwards then curving upwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let assertionInfix = 
             {character = Unicode 0x22A6;  
              glyph = "⊦";  
              name="assertion";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let asteriskInfix = 
             {character = Char '*';  
              glyph = "*";  
              name="asterisk";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let asteriskOperatorInfix = 
             {character = Unicode 0x2217;  
              glyph = "∗";  
              name="asterisk operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let asymptoticallyEqualToInfix = 
             {character = Unicode 0x2243;  
              glyph = "≃";  
              name="asymptotically equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let becauseInfix = 
             {character = Unicode 0x2235;  
              glyph = "∵";  
              name="because";  
              form = Infix;  
              priority = 70;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let betweenInfix = 
             {character = Unicode 0x226C;  
              glyph = "≬";  
              name="between";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let bigReverseSolidusInfix = 
             {character = Unicode 0x29F9;  
              glyph = "⧹";  
              name="big reverse solidus";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let bigSolidusInfix = 
             {character = Unicode 0x29F8;  
              glyph = "⧸";  
              name="big solidus";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let blackBowtieInfix = 
             {character = Unicode 0x29D3;  
              glyph = "⧓";  
              name="black bowtie";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let blackCircleInfix = 
             {character = Unicode 0x25CF;  
              glyph = "●";  
              name="black circle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackCircleWithDownArrowInfix = 
             {character = Unicode 0x29ED;  
              glyph = "⧭";  
              name="black circle with down arrow";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let blackDiamondInfix = 
             {character = Unicode 0x25C6;  
              glyph = "◆";  
              name="black diamond";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackDiamondWithDownArrowInfix = 
             {character = Unicode 0x29EA;  
              glyph = "⧪";  
              name="black diamond with down arrow";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let blackDownPointingSmallTriangleInfix = 
             {character = Unicode 0x25BE;  
              glyph = "▾";  
              name="black down-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackDownPointingTriangleInfix = 
             {character = Unicode 0x25BC;  
              glyph = "▼";  
              name="black down-pointing triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackHourglassInfix = 
             {character = Unicode 0x29D7;  
              glyph = "⧗";  
              name="black hourglass";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackLeftPointingPointerInfix = 
             {character = Unicode 0x25C4;  
              glyph = "◄";  
              name="black left-pointing pointer";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackLeftPointingSmallTriangleInfix = 
             {character = Unicode 0x25C2;  
              glyph = "◂";  
              name="black left-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackLeftPointingTriangleInfix = 
             {character = Unicode 0x25C0;  
              glyph = "◀";  
              name="black left-pointing triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackLozengeInfix = 
             {character = Unicode 0x29EB;  
              glyph = "⧫";  
              name="black lozenge";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let blackParallelogramInfix = 
             {character = Unicode 0x25B0;  
              glyph = "▰";  
              name="black parallelogram";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let blackRightPointingSmallTriangleInfix = 
             {character = Unicode 0x25B8;  
              glyph = "▸";  
              name="black right-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackRightPointingTriangleInfix = 
             {character = Unicode 0x25B6;  
              glyph = "▶";  
              name="black right-pointing triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackSmallSquareInfix = 
             {character = Unicode 0x25AA;  
              glyph = "▪";  
              name="black small square";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let blackSquareInfix = 
             {character = Unicode 0x25A0;  
              glyph = "■";  
              name="black square";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let blackUpPointingSmallTriangleInfix = 
             {character = Unicode 0x25B4;  
              glyph = "▴";  
              name="black up-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackUpPointingTriangleInfix = 
             {character = Unicode 0x25B2;  
              glyph = "▲";  
              name="black up-pointing triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let blackVerticalRectangleInfix = 
             {character = Unicode 0x25AE;  
              glyph = "▮";  
              name="black vertical rectangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let bottomArcAnticlockwiseArrowInfix = 
             {character = Unicode 0x293B;  
              glyph = "⤻";  
              name="bottom arc anticlockwise arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let bottomCurlyBracketPostfix = 
             {character = Unicode 0x23DF;  
              glyph = "⏟";  
              name="bottom curly bracket";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let bottomParenthesisPostfix = 
             {character = Unicode 0x23DD;  
              glyph = "⏝";  
              name="bottom parenthesis";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let bottomSquareBracketPostfix = 
             {character = Unicode 0x23B5;  
              glyph = "⎵";  
              name="bottom square bracket";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let bottomTortoiseShellBracketPostfix = 
             {character = Unicode 0x23E1;  
              glyph = "⏡";  
              name="bottom tortoise shell bracket";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let bowtieInfix = 
             {character = Unicode 0x22C8;  
              glyph = "⋈";  
              name="bowtie";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let bowtieWithLeftHalfBlackInfix = 
             {character = Unicode 0x29D1;  
              glyph = "⧑";  
              name="bowtie with left half black";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let bowtieWithRightHalfBlackInfix = 
             {character = Unicode 0x29D2;  
              glyph = "⧒";  
              name="bowtie with right half black";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let brevePostfix = 
             {character = Unicode 0x2D8;  
              glyph = "˘";  
              name="breve";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let bulletInfix = 
             {character = Unicode 0x2022;  
              glyph = "•";  
              name="bullet";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let bulletOperatorInfix = 
             {character = Unicode 0x2219;  
              glyph = "∙";  
              name="bullet operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let bullseyeInfix = 
             {character = Unicode 0x25CE;  
              glyph = "◎";  
              name="bullseye";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let caronPostfix = 
             {character = Unicode 0x2C7;  
              glyph = "ˇ";  
              name="caron";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let cedillaPostfix = 
             {character = Unicode 0xB8;  
              glyph = "¸";  
              name="cedilla";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let circledAnticlockwiseRotatedDivisionSignInfix = 
             {character = Unicode 0x29BC;  
              glyph = "⦼";  
              name="circled anticlockwise-rotated division sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledAsteriskOperatorInfix = 
             {character = Unicode 0x229B;  
              glyph = "⊛";  
              name="circled asterisk operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledBulletInfix = 
             {character = Unicode 0x29BF;  
              glyph = "⦿";  
              name="circled bullet";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledDashInfix = 
             {character = Unicode 0x229D;  
              glyph = "⊝";  
              name="circled dash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledDivisionSignInfix = 
             {character = Unicode 0x2A38;  
              glyph = "⨸";  
              name="circled division sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledDivisionSlashInfix = 
             {character = Unicode 0x2298;  
              glyph = "⊘";  
              name="circled division slash";  
              form = Infix;  
              priority = 300;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledDotOperatorInfix = 
             {character = Unicode 0x2299;  
              glyph = "⊙";  
              name="circled dot operator";  
              form = Infix;  
              priority = 710;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledEqualsInfix = 
             {character = Unicode 0x229C;  
              glyph = "⊜";  
              name="circled equals";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledGreaterThanInfix = 
             {character = Unicode 0x29C1;  
              glyph = "⧁";  
              name="circled greater-than";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let circleDividedByHorizontalBarAndTopHalfDividedByVerticalBarInfix = 
             {character = Unicode 0x29BA;  
              glyph = "⦺";  
              name="circle divided by horizontal bar and top half divided by vertical bar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledLessThanInfix = 
             {character = Unicode 0x29C0;  
              glyph = "⧀";  
              name="circled less-than";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let circledMinusInfix = 
             {character = Unicode 0x2296;  
              glyph = "⊖";  
              name="circled minus";  
              form = Infix;  
              priority = 300;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledMultiplicationSignWithCircumflexAccentInfix = 
             {character = Unicode 0x2A36;  
              glyph = "⨶";  
              name="circled multiplication sign with circumflex accent";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledParallelInfix = 
             {character = Unicode 0x29B7;  
              glyph = "⦷";  
              name="circled parallel";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledPerpendicularInfix = 
             {character = Unicode 0x29B9;  
              glyph = "⦹";  
              name="circled perpendicular";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledPlusInfix = 
             {character = Unicode 0x2295;  
              glyph = "⊕";  
              name="circled plus";  
              form = Infix;  
              priority = 300;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledReverseSolidusInfix = 
             {character = Unicode 0x29B8;  
              glyph = "⦸";  
              name="circled reverse solidus";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledRingOperatorInfix = 
             {character = Unicode 0x229A;  
              glyph = "⊚";  
              name="circled ring operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledTimesInfix = 
             {character = Unicode 0x2297;  
              glyph = "⊗";  
              name="circled times";  
              form = Infix;  
              priority = 410;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledVerticalBarInfix = 
             {character = Unicode 0x29B6;  
              glyph = "⦶";  
              name="circled vertical bar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circledWhiteBulletInfix = 
             {character = Unicode 0x29BE;  
              glyph = "⦾";  
              name="circled white bullet";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circleWithHorizontalBarInfix = 
             {character = Unicode 0x29B5;  
              glyph = "⦵";  
              name="circle with horizontal bar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let circleWithSmallCircleToTheRightInfix = 
             {character = Unicode 0x29C2;  
              glyph = "⧂";  
              name="circle with small circle to the right";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let circleWithSuperimposedXInfix = 
             {character = Unicode 0x29BB;  
              glyph = "⦻";  
              name="circle with superimposed x";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circleWithTwoHorizontalStrokesToTheRightInfix = 
             {character = Unicode 0x29C3;  
              glyph = "⧃";  
              name="circle with two horizontal strokes to the right";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let circleWithVerticalFillInfix = 
             {character = Unicode 0x25CD;  
              glyph = "◍";  
              name="circle with vertical fill";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let circulationFunctionPrefix = 
             {character = Unicode 0x2A10;  
              glyph = "⨐";  
              name="circulation function";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let circumflexAccentInfix = 
             {character = Char '^';  
              glyph = "^";  
              name="circumflex accent";  
              form = Infix;  
              priority = 780;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let circumflexAccentPostfix = 
             {character = Char '^';  
              glyph = "^";  
              name="circumflex accent";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let clockwiseClosedCircleArrowInfix = 
             {character = Unicode 0x2941;  
              glyph = "⥁";  
              name="clockwise closed circle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let clockwiseContourIntegralPrefix = 
             {character = Unicode 0x2232;  
              glyph = "∲";  
              name="clockwise contour integral";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let clockwiseIntegralPrefix = 
             {character = Unicode 0x2231;  
              glyph = "∱";  
              name="clockwise integral";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let clockwiseOpenCircleArrowInfix = 
             {character = Unicode 0x21BB;  
              glyph = "↻";  
              name="clockwise open circle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let clockwiseTopSemicircleArrowInfix = 
             {character = Unicode 0x21B7;  
              glyph = "↷";  
              name="clockwise top semicircle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let closedIntersectionWithSerifsInfix = 
             {character = Unicode 0x2A4D;  
              glyph = "⩍";  
              name="closed intersection with serifs";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let closedSubsetInfix = 
             {character = Unicode 0x2ACF;  
              glyph = "⫏";  
              name="closed subset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let closedSubsetOrEqualToInfix = 
             {character = Unicode 0x2AD1;  
              glyph = "⫑";  
              name="closed subset or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let closedSupersetInfix = 
             {character = Unicode 0x2AD0;  
              glyph = "⫐";  
              name="closed superset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let closedSupersetOrEqualToInfix = 
             {character = Unicode 0x2AD2;  
              glyph = "⫒";  
              name="closed superset or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let closedUnionWithSerifsAndSmashProductInfix = 
             {character = Unicode 0x2A50;  
              glyph = "⩐";  
              name="closed union with serifs and smash product";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let closedUnionWithSerifsInfix = 
             {character = Unicode 0x2A4C;  
              glyph = "⩌";  
              name="closed union with serifs";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let colonEqualsInfix = 
             {character = Unicode 0x2254;  
              glyph = "≔";  
              name="colon equals";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let colonInfix = 
             {character = Char ':';  
              glyph = ":";  
              name="colon";  
              form = Infix;  
              priority = 100;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[]}
        let combiningCircumflexAccentPostfix = 
             {character = Unicode 0x302;  
              glyph = "̂";  
              name="combining circumflex accent";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let combiningFourDotsAbovePostfix = 
             {character = Unicode 0x20DC;  
              glyph = "⃜";  
              name="combining four dots above";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let combiningInvertedBrevePostfix = 
             {character = Unicode 0x311;  
              glyph = "̑";  
              name="combining inverted breve";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let combiningThreeDotsAbovePostfix = 
             {character = Unicode 0x20DB;  
              glyph = "⃛";  
              name="combining three dots above";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let commaInfix = 
             {character = Char ',';  
              glyph = ",";  
              name="comma";  
              form = Infix;  
              priority = 40;  
              lspace= EM 0.<em>;  
              rspace = NamedLength ThinMathSpace;  
              properties=[Separator true; LineBreakStyle  After]}
        let commercialAtInfix = 
             {character = Char '@';  
              glyph = "@";  
              name="commercial at";  
              form = Infix;  
              priority = 825;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let complementInfix = 
             {character = Unicode 0x2201;  
              glyph = "∁";  
              name="complement";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[]}
        let congruentWithDotAboveInfix = 
             {character = Unicode 0x2A6D;  
              glyph = "⩭";  
              name="congruent with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let containsAsMemberInfix = 
             {character = Unicode 0x220B;  
              glyph = "∋";  
              name="contains as member";  
              form = Infix;  
              priority = 160;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let containsAsNormalSubgroupInfix = 
             {character = Unicode 0x22B3;  
              glyph = "⊳";  
              name="contains as normal subgroup";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let containsAsNormalSubgroupOrEqualToInfix = 
             {character = Unicode 0x22B5;  
              glyph = "⊵";  
              name="contains as normal subgroup or equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let containsWithLongHorizontalStrokeInfix = 
             {character = Unicode 0x22FA;  
              glyph = "⋺";  
              name="contains with long horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let containsWithOverbarInfix = 
             {character = Unicode 0x22FD;  
              glyph = "⋽";  
              name="contains with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let containsWithVerticalBarAtEndOfHorizontalStrokeInfix = 
             {character = Unicode 0x22FB;  
              glyph = "⋻";  
              name="contains with vertical bar at end of horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let contourIntegralPrefix = 
             {character = Unicode 0x222E;  
              glyph = "∮";  
              name="contour integral";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let correspondsToInfix = 
             {character = Unicode 0x2258;  
              glyph = "≘";  
              name="corresponds to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let cubeRootPrefix = 
             {character = Unicode 0x221B;  
              glyph = "∛";  
              name="cube root";  
              form = Prefix;  
              priority = 845;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let curlyLogicalAndInfix = 
             {character = Unicode 0x22CF;  
              glyph = "⋏";  
              name="curly logical and";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let curlyLogicalOrInfix = 
             {character = Unicode 0x22CE;  
              glyph = "⋎";  
              name="curly logical or";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let degreeSignPostfix = 
             {character = Unicode 0xB0;  
              glyph = "°";  
              name="degree sign";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let deltaEqualToInfix = 
             {character = Unicode 0x225C;  
              glyph = "≜";  
              name="delta equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let diaeresisPostfix = 
             {character = Unicode 0xA8;  
              glyph = "¨";  
              name="diaeresis";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let diamondOperatorInfix = 
             {character = Unicode 0x22C4;  
              glyph = "⋄";  
              name="diamond operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let differenceBetweenInfix = 
             {character = Unicode 0x224F;  
              glyph = "≏";  
              name="difference between";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let differenceBetweenWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x224F; Unicode 0x0020; Unicode 0x338|];  
              glyph = "≏̸";  
              name="difference between with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let dividesInfix = 
             {character = Unicode 0x2223;  
              glyph = "∣";  
              name="divides";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let divisionSignInfix = 
             {character = Unicode 0xF7;  
              glyph = "÷";  
              name="division sign";  
              form = Infix;  
              priority = 660;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let divisionSlashInfix = 
             {character = Unicode 0x2215;  
              glyph = "∕";  
              name="division slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[Stretchy true]}
        let divisionTimesInfix = 
             {character = Unicode 0x22C7;  
              glyph = "⋇";  
              name="division times";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doesNotContainAsMemberInfix = 
             {character = Unicode 0x220C;  
              glyph = "∌";  
              name="does not contain as member";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotContainAsNormalSubgroupInfix = 
             {character = Unicode 0x22EB;  
              glyph = "⋫";  
              name="does not contain as normal subgroup";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotContainAsNormalSubgroupOrEqualInfix = 
             {character = Unicode 0x22ED;  
              glyph = "⋭";  
              name="does not contain as normal subgroup or equal";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotDivideInfix = 
             {character = Unicode 0x2224;  
              glyph = "∤";  
              name="does not divide";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotDivideWithReversedNegationSlashInfix = 
             {character = Unicode 0x2AEE;  
              glyph = "⫮";  
              name="does not divide with reversed negation slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotForceInfix = 
             {character = Unicode 0x22AE;  
              glyph = "⊮";  
              name="does not force";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotPrecedeInfix = 
             {character = Unicode 0x2280;  
              glyph = "⊀";  
              name="does not precede";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotPrecedeOrEqualInfix = 
             {character = Unicode 0x22E0;  
              glyph = "⋠";  
              name="does not precede or equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotProveInfix = 
             {character = Unicode 0x22AC;  
              glyph = "⊬";  
              name="does not prove";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotSucceedInfix = 
             {character = Unicode 0x2281;  
              glyph = "⊁";  
              name="does not succeed";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doesNotSucceedOrEqualInfix = 
             {character = Unicode 0x22E1;  
              glyph = "⋡";  
              name="does not succeed or equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let dotAbovePostfix = 
             {character = Unicode 0x2D9;  
              glyph = "˙";  
              name="dot above";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let dotMinusInfix = 
             {character = Unicode 0x2238;  
              glyph = "∸";  
              name="dot minus";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let dotOperatorInfix = 
             {character = Unicode 0x22C5;  
              glyph = "⋅";  
              name="dot operator";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let dotPlusInfix = 
             {character = Unicode 0x2214;  
              glyph = "∔";  
              name="dot plus";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let dottedCircleInfix = 
             {character = Unicode 0x25CC;  
              glyph = "◌";  
              name="dotted circle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let dottedFenceInfix = 
             {character = Unicode 0x2999;  
              glyph = "⦙";  
              name="dotted fence";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let doubleAcuteAccentPostfix = 
             {character = Unicode 0x2DD;  
              glyph = "˝";  
              name="double acute accent";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let doubleColonEqualInfix = 
             {character = Unicode 0x2A74;  
              glyph = "⩴";  
              name="double colon equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleDownTackInfix = 
             {character = Unicode 0x2AEA;  
              glyph = "⫪";  
              name="double down tack";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleEndedMultimapInfix = 
             {character = Unicode 0x29DF;  
              glyph = "⧟";  
              name="double-ended multimap";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let doubleHighReversed9QuotationMarkPostfix = 
             {character = Unicode 0x201F;  
              glyph = "‟";  
              name="double high-reversed-9 quotation mark";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let doubleIntegralPrefix = 
             {character = Unicode 0x222C;  
              glyph = "∬";  
              name="double integral";  
              form = Prefix;  
              priority = 300;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let doubleIntersectionInfix = 
             {character = Unicode 0x22D2;  
              glyph = "⋒";  
              name="double intersection";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doubleLeftArcGreaterThanBracketPrefix = 
             {character = Unicode 0x2995;  
              glyph = "⦕";  
              name="double left arc greater-than bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let doubleLineEqualToOrGreaterThanInfix = 
             {character = Unicode 0x2A9A;  
              glyph = "⪚";  
              name="double-line equal to or greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleLineEqualToOrLessThanInfix = 
             {character = Unicode 0x2A99;  
              glyph = "⪙";  
              name="double-line equal to or less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleLineSlantedEqualToOrGreaterThanInfix = 
             {character = Unicode 0x2A9C;  
              glyph = "⪜";  
              name="double-line slanted equal to or greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleLineSlantedEqualToOrLessThanInfix = 
             {character = Unicode 0x2A9B;  
              glyph = "⪛";  
              name="double-line slanted equal to or less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleLineSlantedGreaterThanOrEqualToInfix = 
             {character = Unicode 0x2AFA;  
              glyph = "⫺";  
              name="double-line slanted greater-than or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleLineSlantedLessThanOrEqualToInfix = 
             {character = Unicode 0x2AF9;  
              glyph = "⫹";  
              name="double-line slanted less-than or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleLogicalAndInfix = 
             {character = Unicode 0x2A53;  
              glyph = "⩓";  
              name="double logical and";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doubleLogicalOrInfix = 
             {character = Unicode 0x2A54;  
              glyph = "⩔";  
              name="double logical or";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doubleLow9QuotationMarkPostfix = 
             {character = Unicode 0x201E;  
              glyph = "„";  
              name="double low-9 quotation mark";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let doubleNestedGreaterThanInfix = 
             {character = Unicode 0x2AA2;  
              glyph = "⪢";  
              name="double nested greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleNestedGreaterThanWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2AA2;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⪢̸";  
              name="double nested greater-than with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleNestedLessThanInfix = 
             {character = Unicode 0x2AA1;  
              glyph = "⪡";  
              name="double nested less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleNestedLessThanWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2AA1;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⪡̸";  
              name="double nested less-than with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleNestedLessThanWithUnderbarInfix = 
             {character = Unicode 0x2AA3;  
              glyph = "⪣";  
              name="double nested less-than with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doublePlusInfix = 
             {character = Unicode 0x29FA;  
              glyph = "⧺";  
              name="double plus";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let doublePrecedesInfix = 
             {character = Unicode 0x2ABB;  
              glyph = "⪻";  
              name="double precedes";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doublePrimePostfix = 
             {character = Unicode 0x2033;  
              glyph = "″";  
              name="double prime";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let doubleRightArcLessThanBracketPostfix = 
             {character = Unicode 0x2996;  
              glyph = "⦖";  
              name="double right arc less-than bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let doubleSolidusOperatorInfix = 
             {character = Unicode 0x2AFD;  
              glyph = "⫽";  
              name="double solidus operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doubleSquareIntersectionInfix = 
             {character = Unicode 0x2A4E;  
              glyph = "⩎";  
              name="double square intersection";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doubleSquareUnionInfix = 
             {character = Unicode 0x2A4F;  
              glyph = "⩏";  
              name="double square union";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doubleStrokeNotSignInfix = 
             {character = Unicode 0x2AEC;  
              glyph = "⫬";  
              name="double stroke not sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleStruckItalicCapitalDPrefix = 
             {character = Unicode 0x2145;  
              glyph = "ⅅ";  
              name="double-struck italic capital d";  
              form = Prefix;  
              priority = 845;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let doubleStruckItalicSmallDPrefix = 
             {character = Unicode 0x2146;  
              glyph = "ⅆ";  
              name="double-struck italic small d";  
              form = Prefix;  
              priority = 845;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace= EM 0.<em>;  
              properties=[]}
        let doubleSubsetInfix = 
             {character = Unicode 0x22D0;  
              glyph = "⋐";  
              name="double subset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleSucceedsInfix = 
             {character = Unicode 0x2ABC;  
              glyph = "⪼";  
              name="double succeeds";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleSupersetInfix = 
             {character = Unicode 0x22D1;  
              glyph = "⋑";  
              name="double superset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleUnionInfix = 
             {character = Unicode 0x22D3;  
              glyph = "⋓";  
              name="double union";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let doubleUpTackInfix = 
             {character = Unicode 0x2AEB;  
              glyph = "⫫";  
              name="double up tack";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleVerticalBarDoubleLeftTurnstileInfix = 
             {character = Unicode 0x2AE5;  
              glyph = "⫥";  
              name="double vertical bar double left turnstile";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleVerticalBarDoubleRightTurnstileInfix = 
             {character = Unicode 0x22AB;  
              glyph = "⊫";  
              name="double vertical bar double right turnstile";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleVerticalBarLeftTurnstileInfix = 
             {character = Unicode 0x2AE3;  
              glyph = "⫣";  
              name="double vertical bar left turnstile";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let doubleVerticalLinePostfix = 
             {character = Unicode 0x2016;  
              glyph = "‖";  
              name="double vertical line";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true]}
        let doubleVerticalLinePrefix = 
             {character = Unicode 0x2016;  
              glyph = "‖";  
              name="double vertical line";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true]}
        let downFishTailInfix = 
             {character = Unicode 0x297F;  
              glyph = "⥿";  
              name="down fish tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let downPointingTriangleWithLeftHalfBlackInfix = 
             {character = Unicode 0x29E8;  
              glyph = "⧨";  
              name="down-pointing triangle with left half black";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let downPointingTriangleWithRightHalfBlackInfix = 
             {character = Unicode 0x29E9;  
              glyph = "⧩";  
              name="down-pointing triangle with right half black";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let downRightDiagonalEllipsisInfix = 
             {character = Unicode 0x22F1;  
              glyph = "⋱";  
              name="down right diagonal ellipsis";  
              form = Infix;  
              priority = 150;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let downTackInfix = 
             {character = Unicode 0x22A4;  
              glyph = "⊤";  
              name="down tack";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let downTackWithCircleBelowInfix = 
             {character = Unicode 0x2AF1;  
              glyph = "⫱";  
              name="down tack with circle below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let downwardsArrowFromBarInfix = 
             {character = Unicode 0x21A7;  
              glyph = "↧";  
              name="downwards arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsArrowInfix = 
             {character = Unicode 0x2193;  
              glyph = "↓";  
              name="downwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsArrowLeftwardsOfUpwardsArrowInfix = 
             {character = Unicode 0x21F5;  
              glyph = "⇵";  
              name="downwards arrow leftwards of upwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsArrowToBarInfix = 
             {character = Unicode 0x2913;  
              glyph = "⤓";  
              name="downwards arrow to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsArrowWithCornerLeftwardsInfix = 
             {character = Unicode 0x21B5;  
              glyph = "↵";  
              name="downwards arrow with corner leftwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsArrowWithDoubleStrokeInfix = 
             {character = Unicode 0x21DF;  
              glyph = "⇟";  
              name="downwards arrow with double stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let downwardsArrowWithHorizontalStrokeInfix = 
             {character = Unicode 0x2908;  
              glyph = "⤈";  
              name="downwards arrow with horizontal stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let downwardsArrowWithTipLeftwardsInfix = 
             {character = Unicode 0x21B2;  
              glyph = "↲";  
              name="downwards arrow with tip leftwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsArrowWithTipRightwardsInfix = 
             {character = Unicode 0x21B3;  
              glyph = "↳";  
              name="downwards arrow with tip rightwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsDashedArrowInfix = 
             {character = Unicode 0x21E3;  
              glyph = "⇣";  
              name="downwards dashed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsDoubleArrowInfix = 
             {character = Unicode 0x21D3;  
              glyph = "⇓";  
              name="downwards double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsHarpoonWithBarbLeftBesideDownwardsHarpoonWithBarbRightInfix = 
             {character = Unicode 0x2965;  
              glyph = "⥥";  
              name="downwards harpoon with barb left beside downwards harpoon with barb right";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let downwardsHarpoonWithBarbLeftBesideUpwardsHarpoonWithBarbRightInfix = 
             {character = Unicode 0x296F;  
              glyph = "⥯";  
              name="downwards harpoon with barb left beside upwards harpoon with barb right";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsHarpoonWithBarbLeftFromBarInfix = 
             {character = Unicode 0x2961;  
              glyph = "⥡";  
              name="downwards harpoon with barb left from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsHarpoonWithBarbLeftToBarInfix = 
             {character = Unicode 0x2959;  
              glyph = "⥙";  
              name="downwards harpoon with barb left to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsHarpoonWithBarbLeftwardsInfix = 
             {character = Unicode 0x21C3;  
              glyph = "⇃";  
              name="downwards harpoon with barb leftwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsHarpoonWithBarbRightFromBarInfix = 
             {character = Unicode 0x295D;  
              glyph = "⥝";  
              name="downwards harpoon with barb right from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsHarpoonWithBarbRightToBarInfix = 
             {character = Unicode 0x2955;  
              glyph = "⥕";  
              name="downwards harpoon with barb right to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsHarpoonWithBarbRightwardsInfix = 
             {character = Unicode 0x21C2;  
              glyph = "⇂";  
              name="downwards harpoon with barb rightwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsPairedArrowsInfix = 
             {character = Unicode 0x21CA;  
              glyph = "⇊";  
              name="downwards paired arrows";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsQuadrupleArrowInfix = 
             {character = Unicode 0x27F1;  
              glyph = "⟱";  
              name="downwards quadruple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsTripleArrowInfix = 
             {character = Unicode 0x290B;  
              glyph = "⤋";  
              name="downwards triple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsTwoHeadedArrowInfix = 
             {character = Unicode 0x21A1;  
              glyph = "↡";  
              name="downwards two headed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsWhiteArrowInfix = 
             {character = Unicode 0x21E9;  
              glyph = "⇩";  
              name="downwards white arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let downwardsZigzagArrowInfix = 
             {character = Unicode 0x21AF;  
              glyph = "↯";  
              name="downwards zigzag arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let elementOfInfix = 
             {character = Unicode 0x2208;  
              glyph = "∈";  
              name="element of";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let elementOfOpeningDownwardsInfix = 
             {character = Unicode 0x2AD9;  
              glyph = "⫙";  
              name="element of opening downwards";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let elementOfWithDotAboveInfix = 
             {character = Unicode 0x22F5;  
              glyph = "⋵";  
              name="element of with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let elementOfWithLongHorizontalStrokeInfix = 
             {character = Unicode 0x22F2;  
              glyph = "⋲";  
              name="element of with long horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let elementOfWithOverbarInfix = 
             {character = Unicode 0x22F6;  
              glyph = "⋶";  
              name="element of with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let elementOfWithTwoHorizontalStrokesInfix = 
             {character = Unicode 0x22F9;  
              glyph = "⋹";  
              name="element of with two horizontal strokes";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let elementOfWithUnderbarInfix = 
             {character = Unicode 0x22F8;  
              glyph = "⋸";  
              name="element of with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let elementOfWithVerticalBarAtEndOfHorizontalStrokeInfix = 
             {character = Unicode 0x22F3;  
              glyph = "⋳";  
              name="element of with vertical bar at end of horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let emptySetWithLeftArrowAboveInfix = 
             {character = Unicode 0x29B4;  
              glyph = "⦴";  
              name="empty set with left arrow above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let emptySetWithOverbarInfix = 
             {character = Unicode 0x29B1;  
              glyph = "⦱";  
              name="empty set with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let emptySetWithRightArrowAboveInfix = 
             {character = Unicode 0x29B3;  
              glyph = "⦳";  
              name="empty set with right arrow above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let emptySetWithSmallCircleAboveInfix = 
             {character = Unicode 0x29B2;  
              glyph = "⦲";  
              name="empty set with small circle above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let endOfProofInfix = 
             {character = Unicode 0x220E;  
              glyph = "∎";  
              name="end of proof";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let equalAndParallelToInfix = 
             {character = Unicode 0x22D5;  
              glyph = "⋕";  
              name="equal and parallel to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsColonInfix = 
             {character = Unicode 0x2255;  
              glyph = "≕";  
              name="equals colon";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsSignAbovePlusSignInfix = 
             {character = Unicode 0x2A71;  
              glyph = "⩱";  
              name="equals sign above plus sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let equalsSignAboveRightwardsArrowInfix = 
             {character = Unicode 0x2971;  
              glyph = "⥱";  
              name="equals sign above rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let equalsSignAboveTildeOperatorInfix = 
             {character = Unicode 0x2A73;  
              glyph = "⩳";  
              name="equals sign above tilde operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsSignAndSlantedParallelInfix = 
             {character = Unicode 0x29E3;  
              glyph = "⧣";  
              name="equals sign and slanted parallel";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsSignAndSlantedParallelWithTildeAboveInfix = 
             {character = Unicode 0x29E4;  
              glyph = "⧤";  
              name="equals sign and slanted parallel with tilde above";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsSignEqualsInfix = 
             {character = Char  '=';  
              glyph = "=";  
              name="equals sign";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsSignWithBumpyAboveInfix = 
             {character = Unicode 0x2AAE;  
              glyph = "⪮";  
              name="equals sign with bumpy above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsSignWithDotBelowInfix = 
             {character = Unicode 0x2A66;  
              glyph = "⩦";  
              name="equals sign with dot below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsSignWithTwoDotsAboveAndTwoDotsBelowInfix = 
             {character = Unicode 0x2A77;  
              glyph = "⩷";  
              name="equals sign with two dots above and two dots below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalsWithAsteriskInfix = 
             {character = Unicode 0x2A6E;  
              glyph = "⩮";  
              name="equals with asterisk";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalToByDefinitionInfix = 
             {character = Unicode 0x225D;  
              glyph = "≝";  
              name="equal to by definition";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalToOrGreaterThanInfix = 
             {character = Unicode 0x22DD;  
              glyph = "⋝";  
              name="equal to or greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalToOrLessThanInfix = 
             {character = Unicode 0x22DC;  
              glyph = "⋜";  
              name="equal to or less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalToOrPrecedesInfix = 
             {character = Unicode 0x22DE;  
              glyph = "⋞";  
              name="equal to or precedes";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equalToOrSucceedsInfix = 
             {character = Unicode 0x22DF;  
              glyph = "⋟";  
              name="equal to or succeeds";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equiangularToInfix = 
             {character = Unicode 0x225A;  
              glyph = "≚";  
              name="equiangular to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equivalentToInfix = 
             {character = Unicode 0x224D;  
              glyph = "≍";  
              name="equivalent to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let equivalentWithFourDotsAboveInfix = 
             {character = Unicode 0x2A78;  
              glyph = "⩸";  
              name="equivalent with four dots above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let errorBarredBlackCircleInfix = 
             {character = Unicode 0x29F3;  
              glyph = "⧳";  
              name="error-barred black circle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let errorBarredBlackDiamondInfix = 
             {character = Unicode 0x29F1;  
              glyph = "⧱";  
              name="error-barred black diamond";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let errorBarredBlackSquareInfix = 
             {character = Unicode 0x29EF;  
              glyph = "⧯";  
              name="error-barred black square";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let errorBarredWhiteCircleInfix = 
             {character = Unicode 0x29F2;  
              glyph = "⧲";  
              name="error-barred white circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let errorBarredWhiteDiamondInfix = 
             {character = Unicode 0x29F0;  
              glyph = "⧰";  
              name="error-barred white diamond";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let errorBarredWhiteSquareInfix = 
             {character = Unicode 0x29EE;  
              glyph = "⧮";  
              name="error-barred white square";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let estimatesInfix = 
             {character = Unicode 0x2259;  
              glyph = "≙";  
              name="estimates";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let excessInfix = 
             {character = Unicode 0x2239;  
              glyph = "∹";  
              name="excess";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let exclamationMarkPostfix = 
             {character = Char  '!';  
              glyph = "!";  
              name="exclamation mark";  
              form = Postfix;  
              priority = 810;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace= EM 0.<em>;  
              properties=[]}
        let fallingDiagonalCrossingNorthEastArrowInfix = 
             {character = Unicode 0x292F;  
              glyph = "⤯";  
              name="falling diagonal crossing north east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let fallingDiagonalCrossingRisingDiagonalInfix = 
             {character = Unicode 0x292C;  
              glyph = "⤬";  
              name="falling diagonal crossing rising diagonal";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let feminineOrdinalIndicatorPostfix = 
             {character = Unicode 0xAA;  
              glyph = "ª";  
              name="feminine ordinal indicator";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let finitePartIntegralPrefix = 
             {character = Unicode 0x2A0D;  
              glyph = "⨍";  
              name="finite part integral";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let fisheyeInfix = 
             {character = Unicode 0x25C9;  
              glyph = "◉";  
              name="fisheye";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let forAllPrefix = 
             {character = Unicode 0x2200;  
              glyph = "∀";  
              name="for all";  
              form = Prefix;  
              priority = 230;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let forcesInfix = 
             {character = Unicode 0x22A9;  
              glyph = "⊩";  
              name="forces";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let fourthRootPrefix = 
             {character = Unicode 0x221C;  
              glyph = "∜";  
              name="fourth root";  
              form = Prefix;  
              priority = 845;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let fractionSlashInfix = 
             {character = Unicode 0x2044;  
              glyph = "⁄";  
              name="fraction slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[Stretchy true]}
        let fullStopInfix = 
             {character = Char  '.';  
              glyph = ".";  
              name="full stop";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let functionApplicationInfix = 
             {character = Unicode 0x2061;  
              glyph = "⁡";  
              name="function application";  
              form = Infix;  
              priority = 850;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let geometricallyEqualToInfix = 
             {character = Unicode 0x2251;  
              glyph = "≑";  
              name="geometrically equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let geometricallyEquivalentToInfix = 
             {character = Unicode 0x224E;  
              glyph = "≎";  
              name="geometrically equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let geometricallyEquivalentToWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x224E;Unicode 0x0020;Unicode 0x338|];  
              glyph = "≎̸";  
              name="geometrically equivalent to with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let geometricProportionInfix = 
             {character = Unicode 0x223A;  
              glyph = "∺";  
              name="geometric proportion";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let gleichStarkInfix = 
             {character = Unicode 0x29E6;  
              glyph = "⧦";  
              name="gleich stark";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let graveAccentPostfix = 
             {character = Char  '`';  
              glyph = "`";  
              name="grave accent";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let greaterThanAboveDoubleLineEqualAboveLessThanInfix = 
             {character = Unicode 0x2A8C;  
              glyph = "⪌";  
              name="greater-than above double-line equal above less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanAboveLessThanAboveDoubleLineEqualInfix = 
             {character = Unicode 0x2A92;  
              glyph = "⪒";  
              name="greater-than above less-than above double-line equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanAboveRightwardsArrowInfix = 
             {character = Unicode 0x2978;  
              glyph = "⥸";  
              name="greater-than above rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let greaterThanAboveSimilarAboveLessThanInfix = 
             {character = Unicode 0x2A90;  
              glyph = "⪐";  
              name="greater-than above similar above less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanAboveSimilarOrEqualInfix = 
             {character = Unicode 0x2A8E;  
              glyph = "⪎";  
              name="greater-than above similar or equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanAboveSlantedEqualAboveLessThanAboveSlantedEqualInfix = 
             {character = Unicode 0x2A94;  
              glyph = "⪔";  
              name="greater-than above slanted equal above less-than above slanted equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanAndNotApproximateInfix = 
             {character = Unicode 0x2A8A;  
              glyph = "⪊";  
              name="greater-than and not approximate";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanAndSingleLineNotEqualToInfix = 
             {character = Unicode 0x2A88;  
              glyph = "⪈";  
              name="greater-than and single-line not equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanBesideLessThanInfix = 
             {character = Unicode 0x2AA5;  
              glyph = "⪥";  
              name="greater-than beside less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanButNotEqualToInfix = 
             {character = Unicode 0x2269;  
              glyph = "≩";  
              name="greater-than but not equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanButNotEquivalentToInfix = 
             {character = Unicode 0x22E7;  
              glyph = "⋧";  
              name="greater-than but not equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanClosedByCurveAboveSlantedEqualInfix = 
             {character = Unicode 0x2AA9;  
              glyph = "⪩";  
              name="greater-than closed by curve above slanted equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanClosedByCurveInfix = 
             {character = Unicode 0x2AA7;  
              glyph = "⪧";  
              name="greater-than closed by curve";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanEqualToOrLessThanInfix = 
             {character = Unicode 0x22DB;  
              glyph = "⋛";  
              name="greater-than equal to or less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrApproximateInfix = 
             {character = Unicode 0x2A86;  
              glyph = "⪆";  
              name="greater-than or approximate";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrEquivalentToInfix = 
             {character = Unicode 0x2273;  
              glyph = "≳";  
              name="greater-than or equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrLessThanInfix = 
             {character = Unicode 0x2277;  
              glyph = "≷";  
              name="greater-than or less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrSlantedEqualToInfix = 
             {character = Unicode 0x2A7E;  
              glyph = "⩾";  
              name="greater-than or slanted equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrSlantedEqualToWithDotAboveInfix = 
             {character = Unicode 0x2A82;  
              glyph = "⪂";  
              name="greater-than or slanted equal to with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrSlantedEqualToWithDotAboveLeftInfix = 
             {character = Unicode 0x2A84;  
              glyph = "⪄";  
              name="greater-than or slanted equal to with dot above left";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrSlantedEqualToWithDotInsideInfix = 
             {character = Unicode 0x2A80;  
              glyph = "⪀";  
              name="greater-than or slanted equal to with dot inside";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOrSlantedEqualToWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2A7E;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⩾̸";  
              name="greater-than or slanted equal to with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOverEqualToInfix = 
             {character = Unicode 0x2267;  
              glyph = "≧";  
              name="greater-than over equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanOverlappingLessThanInfix = 
             {character = Unicode 0x2AA4;  
              glyph = "⪤";  
              name="greater-than overlapping less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanSignInfix = 
             {character = Char  '>';  
              glyph = ">";  
              name="greater-than sign";  
              form = Infix;  
              priority = 243;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanWithCircleInsideInfix = 
             {character = Unicode 0x2A7A;  
              glyph = "⩺";  
              name="greater-than with circle inside";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanWithDotInfix = 
             {character = Unicode 0x22D7;  
              glyph = "⋗";  
              name="greater-than with dot";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greaterThanWithQuestionMarkAboveInfix = 
             {character = Unicode 0x2A7C;  
              glyph = "⩼";  
              name="greater-than with question mark above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greateThanOrEqualToInfix = 
             {character = Unicode 0x2265;  
              glyph = "≥";  
              name="greater-than or equal to";  
              form = Infix;  
              priority = 242;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let greekReversedLunateEpsilonSymbolInfix = 
             {character = Unicode 0x3F6;  
              glyph = "϶";  
              name="greek reversed lunate epsilon symbol";  
              form = Infix;  
              priority = 110;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let hermitianConjugateMatrixInfix = 
             {character = Unicode 0x22B9;  
              glyph = "⊹";  
              name="hermitian conjugate matrix";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let homotheticInfix = 
             {character = Unicode 0x223B;  
              glyph = "∻";  
              name="homothetic";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let horizontalEllipsisInfix = 
             {character = Unicode 0x2026;  
              glyph = "…";  
              name="horizontal ellipsis";  
              form = Infix;  
              priority = 150;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let hyphenBulletInfix = 
             {character = Unicode 0x2043;  
              glyph = "⁃";  
              name="hyphen bullet";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let hyphenMinusInfix = 
             {character = Char  '-';  
              glyph = "-";  
              name="hyphen-minus";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let hyphenMinusPrefix = 
             {character = Char  '-';  
              glyph = "-";  
              name="hyphen-minus";  
              form = Prefix;  
              priority = 275;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let identicalToAndSlantedParallelInfix = 
             {character = Unicode 0x29E5;  
              glyph = "⧥";  
              name="identical to and slanted parallel";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let identicalToInfix = 
             {character = Unicode 0x2261;  
              glyph = "≡";  
              name="identical to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let identicalWithDotAboveInfix = 
             {character = Unicode 0x2A67;  
              glyph = "⩧";  
              name="identical with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let imageOfInfix = 
             {character = Unicode 0x22B7;  
              glyph = "⊷";  
              name="image of";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let imageOfOrApproximatelyEqualToInfix = 
             {character = Unicode 0x2253;  
              glyph = "≓";  
              name="image of or approximately equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let incompleteInfinityInfix = 
             {character = Unicode 0x29DC;  
              glyph = "⧜";  
              name="incomplete infinity";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let increasesAsInfix = 
             {character = Unicode 0x29E1;  
              glyph = "⧡";  
              name="increases as";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let incrementInfix = 
             {character = Unicode 0x2206;  
              glyph = "∆";  
              name="increment";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let infinityNegatedWithVerticalBarInfix = 
             {character = Unicode 0x29DE;  
              glyph = "⧞";  
              name="infinity negated with vertical bar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let integralAroundAPointOperatorPrefix = 
             {character = Unicode 0x2A15;  
              glyph = "⨕";  
              name="integral around a point operator";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralAverageWithSlashPrefix = 
             {character = Unicode 0x2A0F;  
              glyph = "⨏";  
              name="integral average with slash";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralPrefix = 
             {character = Unicode 0x222B;  
              glyph = "∫";  
              name="integral";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralWithDoubleStrokePrefix = 
             {character = Unicode 0x2A0E;  
              glyph = "⨎";  
              name="integral with double stroke";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralWithIntersectionPrefix = 
             {character = Unicode 0x2A19;  
              glyph = "⨙";  
              name="integral with intersection";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralWithLeftwardsArrowWithHookPrefix = 
             {character = Unicode 0x2A17;  
              glyph = "⨗";  
              name="integral with leftwards arrow with hook";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralWithOverbarPrefix = 
             {character = Unicode 0x2A1B;  
              glyph = "⨛";  
              name="integral with overbar";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralWithTimesSignPrefix = 
             {character = Unicode 0x2A18;  
              glyph = "⨘";  
              name="integral with times sign";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralWithUnderbarPrefix = 
             {character = Unicode 0x2A1C;  
              glyph = "⨜";  
              name="integral with underbar";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let integralWithUnionPrefix = 
             {character = Unicode 0x2A1A;  
              glyph = "⨚";  
              name="integral with union";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let intercalateInfix = 
             {character = Unicode 0x22BA;  
              glyph = "⊺";  
              name="intercalate";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let interiorProductInfix = 
             {character = Unicode 0x2A3C;  
              glyph = "⨼";  
              name="interior product";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let intersectionAboveBarAboveUnionInfix = 
             {character = Unicode 0x2A49;  
              glyph = "⩉";  
              name="intersection above bar above union";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let intersectionAboveUnionInfix = 
             {character = Unicode 0x2A47;  
              glyph = "⩇";  
              name="intersection above union";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let intersectionBesideAndJoinedWithIntersectionInfix = 
             {character = Unicode 0x2A4B;  
              glyph = "⩋";  
              name="intersection beside and joined with intersection";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let intersectionInfix = 
             {character = Unicode 0x2229;  
              glyph = "∩";  
              name="intersection";  
              form = Infix;  
              priority = 350;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let intersectionWithDotInfix = 
             {character = Unicode 0x2A40;  
              glyph = "⩀";  
              name="intersection with dot";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let intersectionWithLogicalAndInfix = 
             {character = Unicode 0x2A44;  
              glyph = "⩄";  
              name="intersection with logical and";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let intersectionWithOverbarInfix = 
             {character = Unicode 0x2A43;  
              glyph = "⩃";  
              name="intersection with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let invertedLazySInfix = 
             {character = Unicode 0x223E;  
              glyph = "∾";  
              name="inverted lazy s";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let invisiblePlusInfix = 
             {character = Unicode 0x2064;  
              glyph = "⁤";  
              name="invisible plus";  
              form = Infix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let invisibleSeparatorInfix = 
             {character = Unicode 0x2063;  
              glyph = "⁣";  
              name="invisible separator";  
              form = Infix;  
              priority = 40;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Separator true; LineBreakStyle  After]}
        let invisibleTimesInfix = 
             {character = Unicode 0x2062;  
              glyph = "⁢";  
              name="invisible times";  
              form = Infix;  
              priority = 390;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let joinInfix = 
             {character = Unicode 0x2A1D;  
              glyph = "⨝";  
              name="join";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let largeLeftTriangleOperatorInfix = 
             {character = Unicode 0x2A1E;  
              glyph = "⨞";  
              name="large left triangle operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let largerThanInfix = 
             {character = Unicode 0x2AAB;  
              glyph = "⪫";  
              name="larger than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let largerThanOrEqualToInfix = 
             {character = Unicode 0x2AAD;  
              glyph = "⪭";  
              name="larger than or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let largeTripleVerticalBarOperatorPrefix = 
             {character = Unicode 0x2AFC;  
              glyph = "⫼";  
              name="large triple vertical bar operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let leftAngleBracketWithDotPrefix = 
             {character = Unicode 0x2991;  
              glyph = "⦑";  
              name="left angle bracket with dot";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftArcLessThanBracketPrefix = 
             {character = Unicode 0x2993;  
              glyph = "⦓";  
              name="left arc less-than bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftBarbDownRightBarbDownHarpoonInfix = 
             {character = Unicode 0x2950;  
              glyph = "⥐";  
              name="left barb down right barb down harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftBarbDownRightBarbUpHarpoonInfix = 
             {character = Unicode 0x294B;  
              glyph = "⥋";  
              name="left barb down right barb up harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftBarbUpRightBarbDownHarpoonInfix = 
             {character = Unicode 0x294A;  
              glyph = "⥊";  
              name="left barb up right barb down harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftBarbUpRightBarbUpHarpoonInfix = 
             {character = Unicode 0x294E;  
              glyph = "⥎";  
              name="left barb up right barb up harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftBlackTortoiseShellBracketPrefix = 
             {character = Unicode 0x2997;  
              glyph = "⦗";  
              name="left black tortoise shell bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftCeilingPrefix = 
             {character = Unicode 0x2308;  
              glyph = "⌈";  
              name="left ceiling";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftCurlyBracketPrefix = 
             {character = Char  '{';  
              glyph = "{";  
              name="left curly bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftDoubleQuotationMarkPrefix = 
             {character = Unicode 0x201C;  
              glyph = "“";  
              name="left double quotation mark";  
              form = Prefix;  
              priority = 10;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true]}
        let leftFishTailInfix = 
             {character = Unicode 0x297C;  
              glyph = "⥼";  
              name="left fish tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftFloorPrefix = 
             {character = Unicode 0x230A;  
              glyph = "⌊";  
              name="left floor";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftHalfBlackCircleInfix = 
             {character = Unicode 0x25D6;  
              glyph = "◖";  
              name="left half black circle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let leftNormalFactorSemidirectProductInfix = 
             {character = Unicode 0x22C9;  
              glyph = "⋉";  
              name="left normal factor semidirect product";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let leftParenthesisPrefix = 
             {character = Char  '(';  
              glyph = "(";  
              name="left parenthesis";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftPointingAngleBracketPrefix = 
             {character = Unicode 0x2329;  
              glyph = "〈";  
              name="left-pointing angle bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftPointingCurvedAngleBracketPrefix = 
             {character = Unicode 0x29FC;  
              glyph = "⧼";  
              name="left-pointing curved angle bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftRightArrowInfix = 
             {character = Unicode 0x2194;  
              glyph = "↔";  
              name="left right arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftRightArrowThroughSmallCircleInfix = 
             {character = Unicode 0x2948;  
              glyph = "⥈";  
              name="left right arrow through small circle";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftRightArrowWithDoubleVerticalStrokeInfix = 
             {character = Unicode 0x21FC;  
              glyph = "⇼";  
              name="left right arrow with double vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftRightArrowWithStrokeInfix = 
             {character = Unicode 0x21AE;  
              glyph = "↮";  
              name="left right arrow with stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftRightArrowWithVerticalStrokeInfix = 
             {character = Unicode 0x21F9;  
              glyph = "⇹";  
              name="left right arrow with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftRightDoubleArrowInfix = 
             {character = Unicode 0x21D4;  
              glyph = "⇔";  
              name="left right double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftRightDoubleArrowWithStrokeInfix = 
             {character = Unicode 0x21CE;  
              glyph = "⇎";  
              name="left right double arrow with stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftRightDoubleArrowWithVerticalStrokeInfix = 
             {character = Unicode 0x2904;  
              glyph = "⤄";  
              name="left right double arrow with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftRightOpenHeadedArrowInfix = 
             {character = Unicode 0x21FF;  
              glyph = "⇿";  
              name="left right open-headed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftRightWaveArrowInfix = 
             {character = Unicode 0x21AD;  
              glyph = "↭";  
              name="left right wave arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftSemidirectProductInfix = 
             {character = Unicode 0x22CB;  
              glyph = "⋋";  
              name="left semidirect product";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let leftSideArcAnticlockwiseArrowInfix = 
             {character = Unicode 0x2939;  
              glyph = "⤹";  
              name="left-side arc anticlockwise arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let leftSingleQuotationMarkPrefix = 
             {character = Unicode 0x2018;  
              glyph = "‘";  
              name="left single quotation mark";  
              form = Prefix;  
              priority = 10;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true]}
        let leftSquareBracketPrefix = 
             {character = Char  '[';  
              glyph = "[";  
              name="left square bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftSquareBracketWithTickInBottomCornerPrefix = 
             {character = Unicode 0x298F;  
              glyph = "⦏";  
              name="left square bracket with tick in bottom corner";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftSquareBracketWithTickInTopCornerPrefix = 
             {character = Unicode 0x298D;  
              glyph = "⦍";  
              name="left square bracket with tick in top corner";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftSquareBracketWithUnderbarPrefix = 
             {character = Unicode 0x298B;  
              glyph = "⦋";  
              name="left square bracket with underbar";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftTackInfix = 
             {character = Unicode 0x22A3;  
              glyph = "⊣";  
              name="left tack";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let leftTriangleBesideVerticalBarInfix = 
             {character = Unicode 0x29CF;  
              glyph = "⧏";  
              name="left triangle beside vertical bar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let leftTriangleBesideVerticalBarWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x29CF;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⧏̸";  
              name="left triangle beside vertical bar with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let leftwardsArrowAboveShortRightwardsArrowInfix = 
             {character = Unicode 0x2943;  
              glyph = "⥃";  
              name="leftwards arrow above short rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowAboveTildeOperatorInfix = 
             {character = Unicode 0x2973;  
              glyph = "⥳";  
              name="leftwards arrow above tilde operator";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowFromBarInfix = 
             {character = Unicode 0x21A4;  
              glyph = "↤";  
              name="leftwards arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowFromBarToBlackDiamondInfix = 
             {character = Unicode 0x291F;  
              glyph = "⤟";  
              name="leftwards arrow from bar to black diamond";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowInfix = 
             {character = Unicode 0x2190;  
              glyph = "←";  
              name="leftwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowOverRightwardsArrowInfix = 
             {character = Unicode 0x21C6;  
              glyph = "⇆";  
              name="leftwards arrow over rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowTailInfix = 
             {character = Unicode 0x2919;  
              glyph = "⤙";  
              name="leftwards arrow-tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowThroughLessThanInfix = 
             {character = Unicode 0x2977;  
              glyph = "⥷";  
              name="leftwards arrow through less-than";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowThroughSubsetInfix = 
             {character = Unicode 0x297A;  
              glyph = "⥺";  
              name="leftwards arrow through subset";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowToBarInfix = 
             {character = Unicode 0x21E4;  
              glyph = "⇤";  
              name="leftwards arrow to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowToBarOverRightwardsArrowToBarInfix = 
             {character = Unicode 0x21B9;  
              glyph = "↹";  
              name="leftwards arrow to bar over rightwards arrow to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowToBlackDiamondInfix = 
             {character = Unicode 0x291D;  
              glyph = "⤝";  
              name="leftwards arrow to black diamond";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowWithDoubleVerticalStrokeInfix = 
             {character = Unicode 0x21FA;  
              glyph = "⇺";  
              name="leftwards arrow with double vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowWithHookInfix = 
             {character = Unicode 0x21A9;  
              glyph = "↩";  
              name="leftwards arrow with hook";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowWithLoopInfix = 
             {character = Unicode 0x21AB;  
              glyph = "↫";  
              name="leftwards arrow with loop";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowWithPlusBelowInfix = 
             {character = Unicode 0x2946;  
              glyph = "⥆";  
              name="leftwards arrow with plus below";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowWithStrokeInfix = 
             {character = Unicode 0x219A;  
              glyph = "↚";  
              name="leftwards arrow with stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsArrowWithTailInfix = 
             {character = Unicode 0x21A2;  
              glyph = "↢";  
              name="leftwards arrow with tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsArrowWithVerticalStrokeInfix = 
             {character = Unicode 0x21F7;  
              glyph = "⇷";  
              name="leftwards arrow with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsDashedArrowInfix = 
             {character = Unicode 0x21E0;  
              glyph = "⇠";  
              name="leftwards dashed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsDoubleArrowFromBarInfix = 
             {character = Unicode 0x2906;  
              glyph = "⤆";  
              name="leftwards double arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsDoubleArrowInfix = 
             {character = Unicode 0x21D0;  
              glyph = "⇐";  
              name="leftwards double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsDoubleArrowTailInfix = 
             {character = Unicode 0x291B;  
              glyph = "⤛";  
              name="leftwards double arrow-tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsDoubleArrowWithStrokeInfix = 
             {character = Unicode 0x21CD;  
              glyph = "⇍";  
              name="leftwards double arrow with stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsDoubleArrowWithVerticalStrokeInfix = 
             {character = Unicode 0x2902;  
              glyph = "⤂";  
              name="leftwards double arrow with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsDoubleDashArrowInfix = 
             {character = Unicode 0x290C;  
              glyph = "⤌";  
              name="leftwards double dash arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsHarpoonOverRightwardsHarpoonInfix = 
             {character = Unicode 0x21CB;  
              glyph = "⇋";  
              name="leftwards harpoon over rightwards harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsHarpoonWithBarbDownAboveRightwardsHarpoonWithBarbDownInfix = 
             {character = Unicode 0x2967;  
              glyph = "⥧";  
              name="leftwards harpoon with barb down above rightwards harpoon with barb down";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsHarpoonWithBarbDownBelowLongDashInfix = 
             {character = Unicode 0x296B;  
              glyph = "⥫";  
              name="leftwards harpoon with barb down below long dash";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsHarpoonWithBarbDownFromBarInfix = 
             {character = Unicode 0x295E;  
              glyph = "⥞";  
              name="leftwards harpoon with barb down from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsHarpoonWithBarbDownToBarInfix = 
             {character = Unicode 0x2956;  
              glyph = "⥖";  
              name="leftwards harpoon with barb down to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let leftwardsHarpoonWithBarbDownwardsInfix = 
             {character = Unicode 0x21BD;  
              glyph = "↽";  
              name="leftwards harpoon with barb downwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsHarpoonWithBarbUpAboveLeftwardsHarpoonWithBarbDownInfix = 
             {character = Unicode 0x2962;  
              glyph = "⥢";  
              name="leftwards harpoon with barb up above leftwards harpoon with barb down";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsHarpoonWithBarbUpAboveLongDashInfix = 
             {character = Unicode 0x296A;  
              glyph = "⥪";  
              name="leftwards harpoon with barb up above long dash";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsHarpoonWithBarbUpAboveRightwardsHarpoonWithBarbUpInfix = 
             {character = Unicode 0x2966;  
              glyph = "⥦";  
              name="leftwards harpoon with barb up above rightwards harpoon with barb up";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let leftwardsHarpoonWithBarbUpFromBarInfix = 
             {character = Unicode 0x295A;  
              glyph = "⥚";  
              name="leftwards harpoon with barb up from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsHarpoonWithBarbUpToBarInfix = 
             {character = Unicode 0x2952;  
              glyph = "⥒";  
              name="leftwards harpoon with barb up to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsHarpoonWithBarbUpwardsInfix = 
             {character = Unicode 0x21BC;  
              glyph = "↼";  
              name="leftwards harpoon with barb upwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsOpenHeadedArrowInfix = 
             {character = Unicode 0x21FD;  
              glyph = "⇽";  
              name="leftwards open-headed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsPairedArrowsInfix = 
             {character = Unicode 0x21C7;  
              glyph = "⇇";  
              name="leftwards paired arrows";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsQuadrupleArrowInfix = 
             {character = Unicode 0x2B45;  
              glyph = "⭅";  
              name="leftwards quadruple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let leftwardsSquiggleArrowInfix = 
             {character = Unicode 0x21DC;  
              glyph = "⇜";  
              name="leftwards squiggle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsTripleArrowInfix = 
             {character = Unicode 0x21DA;  
              glyph = "⇚";  
              name="leftwards triple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsTripleDashArrowInfix = 
             {character = Unicode 0x290E;  
              glyph = "⤎";  
              name="leftwards triple dash arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsTwoHeadedArrowInfix = 
             {character = Unicode 0x219E;  
              glyph = "↞";  
              name="leftwards two headed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsWaveArrowInfix = 
             {character = Unicode 0x219C;  
              glyph = "↜";  
              name="leftwards wave arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftwardsWhiteArrowInfix = 
             {character = Unicode 0x21E6;  
              glyph = "⇦";  
              name="leftwards white arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let leftWhiteCurlyBracketPrefix = 
             {character = Unicode 0x2983;  
              glyph = "⦃";  
              name="left white curly bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftWhiteParenthesisPrefix = 
             {character = Unicode 0x2985;  
              glyph = "⦅";  
              name="left white parenthesis";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let leftWigglyFenceInfix = 
             {character = Unicode 0x29D8;  
              glyph = "⧘";  
              name="left wiggly fence";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let lessThanAboveDoubleLineEqualAboveGreaterThanInfix = 
             {character = Unicode 0x2A8B;  
              glyph = "⪋";  
              name="less-than above double-line equal above greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanAboveGreaterThanAboveDoubleLineEqualInfix = 
             {character = Unicode 0x2A91;  
              glyph = "⪑";  
              name="less-than above greater-than above double-line equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanAboveLeftwardsArrowInfix = 
             {character = Unicode 0x2976;  
              glyph = "⥶";  
              name="less-than above leftwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let lessThanAboveSimilarAboveGreaterThanInfix = 
             {character = Unicode 0x2A8F;  
              glyph = "⪏";  
              name="less-than above similar above greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanAboveSimilarOrEqualInfix = 
             {character = Unicode 0x2A8D;  
              glyph = "⪍";  
              name="less-than above similar or equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanAboveSlantedEqualAboveGreaterThanAboveSlantedEqualInfix = 
             {character = Unicode 0x2A93;  
              glyph = "⪓";  
              name="less-than above slanted equal above greater-than above slanted equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanAndNotApproximateInfix = 
             {character = Unicode 0x2A89;  
              glyph = "⪉";  
              name="less-than and not approximate";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanAndSingleLineNotEqualToInfix = 
             {character = Unicode 0x2A87;  
              glyph = "⪇";  
              name="less-than and single-line not equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanButNotEqualToInfix = 
             {character = Unicode 0x2268;  
              glyph = "≨";  
              name="less-than but not equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanButNotEquivalentToInfix = 
             {character = Unicode 0x22E6;  
              glyph = "⋦";  
              name="less-than but not equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanClosedByCurveAboveSlantedEqualInfix = 
             {character = Unicode 0x2AA8;  
              glyph = "⪨";  
              name="less-than closed by curve above slanted equal";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanClosedByCurveInfix = 
             {character = Unicode 0x2AA6;  
              glyph = "⪦";  
              name="less-than closed by curve";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanEqualToOrGreaterThanInfix = 
             {character = Unicode 0x22DA;  
              glyph = "⋚";  
              name="less-than equal to or greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrApproximateInfix = 
             {character = Unicode 0x2A85;  
              glyph = "⪅";  
              name="less-than or approximate";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrEqualToInfix = 
             {character = Unicode 0x2264;  
              glyph = "≤";  
              name="less-than or equal to";  
              form = Infix;  
              priority = 241;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrEquivalentToInfix = 
             {character = Unicode 0x2272;  
              glyph = "≲";  
              name="less-than or equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrGreaterThanInfix = 
             {character = Unicode 0x2276;  
              glyph = "≶";  
              name="less-than or greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrSlantedEqualToInfix = 
             {character = Unicode 0x2A7D;  
              glyph = "⩽";  
              name="less-than or slanted equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrSlantedEqualToWithDotAboveInfix = 
             {character = Unicode 0x2A81;  
              glyph = "⪁";  
              name="less-than or slanted equal to with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrSlantedEqualToWithDotAboveRightInfix = 
             {character = Unicode 0x2A83;  
              glyph = "⪃";  
              name="less-than or slanted equal to with dot above right";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrSlantedEqualToWithDotInsideInfix = 
             {character = Unicode 0x2A7F;  
              glyph = "⩿";  
              name="less-than or slanted equal to with dot inside";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOrSlantedEqualToWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2A7D;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⩽̸";  
              name="less-than or slanted equal to with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOverEqualToInfix = 
             {character = Unicode 0x2266;  
              glyph = "≦";  
              name="less-than over equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanOverEqualToWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2266;Unicode 0x0020;Unicode 0x338|];  
              glyph = "≦̸";  
              name="less-than over equal to with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanSignInfix = 
             {character = Char '<';  
              glyph = "<";  
              name="less-than sign";  
              form = Infix;  
              priority = 245;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanWithCircleInsideInfix = 
             {character = Unicode 0x2A79;  
              glyph = "⩹";  
              name="less-than with circle inside";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanWithDotInfix = 
             {character = Unicode 0x22D6;  
              glyph = "⋖";  
              name="less-than with dot";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lessThanWithQuestionMarkAboveInfix = 
             {character = Unicode 0x2A7B;  
              glyph = "⩻";  
              name="less-than with question mark above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lightLeftTortoiseShellBracketOrnamentPrefix = 
             {character = Unicode 0x2772;  
              glyph = "❲";  
              name="light left tortoise shell bracket ornament";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let lightRightTortoiseShellBracketOrnamentPostfix = 
             {character = Unicode 0x2773;  
              glyph = "❳";  
              name="light right tortoise shell bracket ornament";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let lightVerticalBarInfix = 
             {character = Unicode 0x2758;  
              glyph = "❘";  
              name="light vertical bar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lineIntegrationNotIncludingThePolePrefix = 
             {character = Unicode 0x2A14;  
              glyph = "⨔";  
              name="line integration not including the pole";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let lineIntegrationWithRectangularPathAroundPolePrefix = 
             {character = Unicode 0x2A12;  
              glyph = "⨒";  
              name="line integration with rectangular path around pole";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let lineIntegrationWithSemicircularPathAroundPolePrefix = 
             {character = Unicode 0x2A13;  
              glyph = "⨓";  
              name="line integration with semicircular path around pole";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let logicalAndInfix = 
             {character = Unicode 0x2227;  
              glyph = "∧";  
              name="logical and";  
              form = Infix;  
              priority = 200;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalAndWithDotAboveInfix = 
             {character = Unicode 0x2A51;  
              glyph = "⩑";  
              name="logical and with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalAndWithDoubleOverbarInfix = 
             {character = Unicode 0x2A5E;  
              glyph = "⩞";  
              name="logical and with double overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalAndWithDoubleUnderbarInfix = 
             {character = Unicode 0x2A60;  
              glyph = "⩠";  
              name="logical and with double underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalAndWithHorizontalDashInfix = 
             {character = Unicode 0x2A5C;  
              glyph = "⩜";  
              name="logical and with horizontal dash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalAndWithMiddleStemInfix = 
             {character = Unicode 0x2A5A;  
              glyph = "⩚";  
              name="logical and with middle stem";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalAndWithUnderbarInfix = 
             {character = Unicode 0x2A5F;  
              glyph = "⩟";  
              name="logical and with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalOrInfix = 
             {character = Unicode 0x2228;  
              glyph = "∨";  
              name="logical or";  
              form = Infix;  
              priority = 190;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalOrOverlappingLogicalAndInfix = 
             {character = Unicode 0x2A59;  
              glyph = "⩙";  
              name="logical or overlapping logical and";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let logicalOrWithDotAboveInfix = 
             {character = Unicode 0x2A52;  
              glyph = "⩒";  
              name="logical or with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalOrWithDoubleOverbarInfix = 
             {character = Unicode 0x2A62;  
              glyph = "⩢";  
              name="logical or with double overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalOrWithDoubleUnderbarInfix = 
             {character = Unicode 0x2A63;  
              glyph = "⩣";  
              name="logical or with double underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalOrWithHorizontalDashInfix = 
             {character = Unicode 0x2A5D;  
              glyph = "⩝";  
              name="logical or with horizontal dash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let logicalOrWithMiddleStemInfix = 
             {character = Unicode 0x2A5B;  
              glyph = "⩛";  
              name="logical or with middle stem";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let longDashFromLeftMemberOfDoubleVerticalInfix = 
             {character = Unicode 0x2AE6;  
              glyph = "⫦";  
              name="long dash from left member of double vertical";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let longLeftRightArrowInfix = 
             {character = Unicode 0x27F7;  
              glyph = "⟷";  
              name="long left right arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longLeftRightDoubleArrowInfix = 
             {character = Unicode 0x27FA;  
              glyph = "⟺";  
              name="long left right double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longLeftwardsArrowFromBarInfix = 
             {character = Unicode 0x27FB;  
              glyph = "⟻";  
              name="long leftwards arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longLeftwardsArrowInfix = 
             {character = Unicode 0x27F5;  
              glyph = "⟵";  
              name="long leftwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longLeftwardsDoubleArrowFromBarInfix = 
             {character = Unicode 0x27FD;  
              glyph = "⟽";  
              name="long leftwards double arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longLeftwardsDoubleArrowInfix = 
             {character = Unicode 0x27F8;  
              glyph = "⟸";  
              name="long leftwards double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longRightwardsArrowFromBarInfix = 
             {character = Unicode 0x27FC;  
              glyph = "⟼";  
              name="long rightwards arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longRightwardsArrowInfix = 
             {character = Unicode 0x27F6;  
              glyph = "⟶";  
              name="long rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longRightwardsDoubleArrowFromBarInfix = 
             {character = Unicode 0x27FE;  
              glyph = "⟾";  
              name="long rightwards double arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longRightwardsDoubleArrowInfix = 
             {character = Unicode 0x27F9;  
              glyph = "⟹";  
              name="long rightwards double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let longRightwardsSquiggleArrowInfix = 
             {character = Unicode 0x27FF;  
              glyph = "⟿";  
              name="long rightwards squiggle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let lowerLeftSemicircularAnticlockwiseArrowInfix = 
             {character = Unicode 0x293F;  
              glyph = "⤿";  
              name="lower left semicircular anticlockwise arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lowerRightSemicircularClockwiseArrowInfix = 
             {character = Unicode 0x293E;  
              glyph = "⤾";  
              name="lower right semicircular clockwise arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let lowLineInfix = 
             {character = Char  '_';  
              glyph = "_";  
              name="low line";  
              form = Infix;  
              priority = 900;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let lowLinePostfix = 
             {character = Char  '_';  
              glyph = "_";  
              name="low line";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let macronPostfix = 
             {character = Unicode 0xAF;  
              glyph = "¯";  
              name="macron";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let masculineOrdinalIndicatorPostfix = 
             {character = Unicode 0xBA;  
              glyph = "º";  
              name="masculine ordinal indicator";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let mathematicalLeftAngleBracketPrefix = 
             {character = Unicode 0x27E8;  
              glyph = "⟨";  
              name="mathematical left angle bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalLeftDoubleAngleBracketPrefix = 
             {character = Unicode 0x27EA;  
              glyph = "⟪";  
              name="mathematical left double angle bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalLeftFlattenedParenthesisPrefix = 
             {character = Unicode 0x27EE;  
              glyph = "⟮";  
              name="mathematical left flattened parenthesis";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalLeftWhiteSquareBracketPrefix = 
             {character = Unicode 0x27E6;  
              glyph = "⟦";  
              name="mathematical left white square bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalLeftWhiteTortoiseShellBracketPrefix = 
             {character = Unicode 0x27EC;  
              glyph = "⟬";  
              name="mathematical left white tortoise shell bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalRightAngleBracketPostfix = 
             {character = Unicode 0x27E9;  
              glyph = "⟩";  
              name="mathematical right angle bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalRightDoubleAngleBracketPostfix = 
             {character = Unicode 0x27EB;  
              glyph = "⟫";  
              name="mathematical right double angle bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalRightFlattenedParenthesisPostfix = 
             {character = Unicode 0x27EF;  
              glyph = "⟯";  
              name="mathematical right flattened parenthesis";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalRightWhiteSquareBracketPostfix = 
             {character = Unicode 0x27E7;  
              glyph = "⟧";  
              name="mathematical right white square bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let mathematicalRightWhiteTortoiseShellBracketPostfix = 
             {character = Unicode 0x27ED;  
              glyph = "⟭";  
              name="mathematical right white tortoise shell bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let measuredAngleOpeningLeftInfix = 
             {character = Unicode 0x299B;  
              glyph = "⦛";  
              name="measured angle opening left";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAnglePrefix = 
             {character = Unicode 0x2221;  
              glyph = "∡";  
              name="measured angle";  
              form = Prefix;  
              priority = 670;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingDownAndLeftInfix = 
             {character = Unicode 0x29AB;  
              glyph = "⦫";  
              name="measured angle with open arm ending in arrow pointing down and left";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingDownAndRightInfix = 
             {character = Unicode 0x29AA;  
              glyph = "⦪";  
              name="measured angle with open arm ending in arrow pointing down and right";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingLeftAndDownInfix = 
             {character = Unicode 0x29AF;  
              glyph = "⦯";  
              name="measured angle with open arm ending in arrow pointing left and down";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingLeftAndUpInfix = 
             {character = Unicode 0x29AD;  
              glyph = "⦭";  
              name="measured angle with open arm ending in arrow pointing left and up";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingRightAndDownInfix = 
             {character = Unicode 0x29AE;  
              glyph = "⦮";  
              name="measured angle with open arm ending in arrow pointing right and down";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingRightAndUpInfix = 
             {character = Unicode 0x29AC;  
              glyph = "⦬";  
              name="measured angle with open arm ending in arrow pointing right and up";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingUpAndLeftInfix = 
             {character = Unicode 0x29A9;  
              glyph = "⦩";  
              name="measured angle with open arm ending in arrow pointing up and left";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredAngleWithOpenArmEndingInArrowPointingUpAndRightInfix = 
             {character = Unicode 0x29A8;  
              glyph = "⦨";  
              name="measured angle with open arm ending in arrow pointing up and right";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let measuredByInfix = 
             {character = Unicode 0x225E;  
              glyph = "≞";  
              name="measured by";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let measuredRightAngleWithDotInfix = 
             {character = Unicode 0x299D;  
              glyph = "⦝";  
              name="measured right angle with dot";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let middleDotInfix = 
             {character = Unicode 0xB7;  
              glyph = "·";  
              name="middle dot";  
              form = Infix;  
              priority = 400;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let midlineHorizontalEllipsisInfix = 
             {character = Unicode 0x22EF;  
              glyph = "⋯";  
              name="midline horizontal ellipsis";  
              form = Infix;  
              priority = 150;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let minusOrPlusSignInfix = 
             {character = Unicode 0x2213;  
              glyph = "∓";  
              name="minus-or-plus sign";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let minusOrPlusSignPrefix = 
             {character = Unicode 0x2213;  
              glyph = "∓";  
              name="minus-or-plus sign";  
              form = Prefix;  
              priority = 275;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let minusSignInfix = 
             {character = Unicode 0x2212;  
              glyph = "−";  
              name="minus sign";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let minusSignInTriangleInfix = 
             {character = Unicode 0x2A3A;  
              glyph = "⨺";  
              name="minus sign in triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let minusSignPrefix = 
             {character = Unicode 0x2212;  
              glyph = "−";  
              name="minus sign";  
              form = Prefix;  
              priority = 275;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let minusSignWithCommaAboveInfix = 
             {character = Unicode 0x2A29;  
              glyph = "⨩";  
              name="minus sign with comma above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let minusSignWithDotBelowInfix = 
             {character = Unicode 0x2A2A;  
              glyph = "⨪";  
              name="minus sign with dot below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let minusSignWithFallingDotsInfix = 
             {character = Unicode 0x2A2B;  
              glyph = "⨫";  
              name="minus sign with falling dots";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let minusSignWithRisingDotsInfix = 
             {character = Unicode 0x2A2C;  
              glyph = "⨬";  
              name="minus sign with rising dots";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let minusTildeInfix = 
             {character = Unicode 0x2242;  
              glyph = "≂";  
              name="minus tilde";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let minusTildeWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2242;Unicode 0x0020;Unicode 0x338|];  
              glyph = "≂̸";  
              name="minus tilde with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let minyInfix = 
             {character = Unicode 0x29FF;  
              glyph = "⧿";  
              name="miny";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let modelsInfix = 
             {character = Unicode 0x22A7;  
              glyph = "⊧";  
              name="models";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let modifierLetterAcuteAccentPostfix = 
             {character = Unicode 0x2CA;  
              glyph = "ˊ";  
              name="modifier letter acute accent";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let modifierLetterCircumflexAccentPostfix = 
             {character = Unicode 0x2C6;  
              glyph = "ˆ";  
              name="modifier letter circumflex accent";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let modifierLetterGraveAccentPostfix = 
             {character = Unicode 0x2CB;  
              glyph = "ˋ";  
              name="modifier letter grave accent";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let modifierLetterLowMacronPostfix = 
             {character = Unicode 0x2CD;  
              glyph = "ˍ";  
              name="modifier letter low macron";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let modifierLetterLowTildePostfix = 
             {character = Unicode 0x2F7;  
              glyph = "˷";  
              name="modifier letter low tilde";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let modifierLetterMacronPostfix = 
             {character = Unicode 0x2C9;  
              glyph = "ˉ";  
              name="modifier letter macron";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let moduloTwoSumPrefix = 
             {character = Unicode 0x2A0A;  
              glyph = "⨊";  
              name="modulo two sum";  
              form = Prefix;  
              priority = 290;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let muchGreaterThanInfix = 
             {character = Unicode 0x226B;  
              glyph = "≫";  
              name="much greater-than";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let muchGreaterThanWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x226B;Unicode 0x0020;Unicode 0x338|];  
              glyph = "≫̸";  
              name="much greater than with slash";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let muchLessThanInfix = 
             {character = Unicode 0x226A;  
              glyph = "≪";  
              name="much less-than";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let muchLessThanWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x226A;Unicode 0x0020;Unicode 0x338|];  
              glyph = "≪̸";  
              name="much less than with slash";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let multimapInfix = 
             {character = Unicode 0x22B8;  
              glyph = "⊸";  
              name="multimap";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let multipleCharacterOperatorDoubleExclamationPostfix = 
             {character = UnicodeArray [| Char '!'; Char '!'|];  
              glyph = "!!";  
              name="multiple character operator: !!";  
              form = Postfix;  
              priority = 810;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace= EM 0.<em>;  
              properties=[]}
        let multipleCharacterOperatorDoubleForwardSlashInfix = 
             {character = UnicodeArray [| Char '/'; Char '/'|];  
              glyph = "//";  
              name="multiple character operator: //";  
              form = Infix;  
              priority = 820;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let multipleCharacterOperatorDoubleMinusPostfix = 
             {character = UnicodeArray [| Char  '-'; Char '-'|];  
              glyph = "--";  
              name="multiple character operator: --";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let multipleCharacterOperatorDoublePlusPostfix = 
             {character = UnicodeArray [| Char  '+'; Char '+'|];  
              glyph = "++";  
              name="multiple character operator: ++";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let multipleCharacterOperatorDoubleVerticalLineInfix = 
             {character = UnicodeArray [| Char  '|'; Char '|'|];  
              glyph = "||";  
              name="multiple character operator: ||";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let multipleCharacterOperatorEqualsEqualsInfix = 
             {character = UnicodeArray [| Char  '='; Char '='|];  
              glyph = "==";  
              name="multiple character operator: ==";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorExclamationEqualsInfix = 
             {character = UnicodeArray [| Char  '!'; Char '='|];  
              glyph = "!=";  
              name="multiple character operator: !=";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorForwardSlashEqualsInfix = 
             {character = UnicodeArray [| Char  '/'; Char '='|];  
              glyph = "/=";  
              name="multiple character operator: /=";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorGreaterThanOrEqualsInfix = 
             {character = UnicodeArray [| Char  '>'; Char '='|];  
              glyph = ">=";  
              name="multiple character operator: >=";  
              form = Infix;  
              priority = 243;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let multipleCharacterOperatorLessThanEqualToInfix = 
             {character = UnicodeArray [| Char  '<'; Char '='|];  
              glyph = "<=";  
              name="multiple character operator: <=";  
              form = Infix;  
              priority = 241;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let multipleCharacterOperatorLessThanOrGreaterThanInfix = 
             {character = UnicodeArray [| Char  '<'; Char '>'|];  
              glyph = "<>";  
              name="multiple character operator: <>";  
              form = Infix;  
              priority = 780;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let multipleCharacterOperatorMinusEqualsInfix = 
             {character = UnicodeArray [| Char  '-'; Char '='|];  
              glyph = "-=";  
              name="multiple character operator: -=";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorMinusGreaterThanInfix = 
             {character = UnicodeArray [| Char  '-'; Char '>'|];  
              glyph = "->";  
              name="multiple character operator: ->";  
              form = Infix;  
              priority = 90;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let multipleCharacterOperatorPlusEqualsInfix = 
             {character = UnicodeArray [| Char  '+'; Char '='|];  
              glyph = "+=";  
              name="multiple character operator: +=";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorSemiColonEqualsInfix = 
             {character = UnicodeArray [| Char  ':'; Char '='|];  
              glyph = ":=";  
              name="multiple character operator: :=";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorStarEqualsInfix = 
             {character = UnicodeArray [| Char  '*'; Char '='|];  
              glyph = "*=";  
              name="multiple character operator: *=";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorThreeDotPostfix = 
             {character = UnicodeArray [| Char  '.'; Char '.'; Char '.'|];  
              glyph = "...";  
              name="multiple character operator: ...";  
              form = Postfix;  
              priority = 100;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let multipleCharacterOperatorTripleVerticalLineInfix = 
             {character = UnicodeArray [| Char  '|'; Char '|'; Char '|'|];  
              glyph = "|||";  
              name="multiple character operator: |||";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let multipleCharacterOperatorTwoAmpersandInfix = 
             {character = UnicodeArray [| Char  '&'; Char '&'|];  
              glyph = "&&";  
              name="multiple character operator: &&";  
              form = Infix;  
              priority = 200;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multipleCharacterOperatorTwoDotPostfix = 
             {character = UnicodeArray [| Char  '.'; Char '.'|];  
              glyph = "..";  
              name="multiple character operator: ..";  
              form = Postfix;  
              priority = 100;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let multipleCharacterOperatorTwoStarInfix = 
             {character = UnicodeArray [| Char  '*'; Char '*'|];  
              glyph = "**";  
              name="multiple character operator: **";  
              form = Infix;  
              priority = 780;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let multipleCharacterThreeVerticalLineOperatorPostfix = 
             {character = UnicodeArray [| Char  '|'; Char '|'; Char '|'|];  
              glyph = "|||";  
              name="multiple character operator: |||";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let multipleCharacterThreeVerticalLineOperatorPrefix = 
             {character = UnicodeArray [| Char  '|'; Char '|'; Char '|'|];  
              glyph = "|||";  
              name="multiple character operator: |||";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let multipleCharacterTwoVerticalLineOperatorPostfix = 
             {character = UnicodeArray [| Char  '|'; Char '|'|];  
              glyph = "||";  
              name="multiple character operator: ||";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let multipleCharacterTwoVerticalLineOperatorPrefix = 
             {character = UnicodeArray [| Char  '|'; Char '|'|];  
              glyph = "||";  
              name="multiple character operator: ||";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let multiplicationSignInDoubleCircleInfix = 
             {character = Unicode 0x2A37;  
              glyph = "⨷";  
              name="multiplication sign in double circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multiplicationSignInfix = 
             {character = Unicode 0xD7;  
              glyph = "×";  
              name="multiplication sign";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multiplicationSignInLeftHalfCircleInfix = 
             {character = Unicode 0x2A34;  
              glyph = "⨴";  
              name="multiplication sign in left half circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multiplicationSignInRightHalfCircleInfix = 
             {character = Unicode 0x2A35;  
              glyph = "⨵";  
              name="multiplication sign in right half circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multiplicationSignInTriangleInfix = 
             {character = Unicode 0x2A3B;  
              glyph = "⨻";  
              name="multiplication sign in triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multiplicationSignWithDotAboveInfix = 
             {character = Unicode 0x2A30;  
              glyph = "⨰";  
              name="multiplication sign with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multiplicationSignWithUnderbarInfix = 
             {character = Unicode 0x2A31;  
              glyph = "⨱";  
              name="multiplication sign with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multisetInfix = 
             {character = Unicode 0x228C;  
              glyph = "⊌";  
              name="multiset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multisetMultiplicationInfix = 
             {character = Unicode 0x228D;  
              glyph = "⊍";  
              name="multiset multiplication";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let multisetUnionInfix = 
             {character = Unicode 0x228E;  
              glyph = "⊎";  
              name="multiset union";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let musicFlatSignPostfix = 
             {character = Unicode 0x266D;  
              glyph = "♭";  
              name="music flat sign";  
              form = Postfix;  
              priority = 800;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[]}
        let musicNaturalSignPostfix = 
             {character = Unicode 0x266E;  
              glyph = "♮";  
              name="music natural sign";  
              form = Postfix;  
              priority = 800;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[]}
        let musicSharpSignPostfix = 
             {character = Unicode 0x266F;  
              glyph = "♯";  
              name="music sharp sign";  
              form = Postfix;  
              priority = 800;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[]}
        let nablaPrefix = 
             {character = Unicode 0x2207;  
              glyph = "∇";  
              name="nabla";  
              form = Prefix;  
              priority = 740;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let nandInfix = 
             {character = Unicode 0x22BC;  
              glyph = "⊼";  
              name="nand";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let nAryCircledDotOperatorPrefix = 
             {character = Unicode 0x2A00;  
              glyph = "⨀";  
              name="n-ary circled dot operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryCircledPlusOperatorPrefix = 
             {character = Unicode 0x2A01;  
              glyph = "⨁";  
              name="n-ary circled plus operator";  
              form = Prefix;  
              priority = 300;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryCircledTimesOperatorPrefix = 
             {character = Unicode 0x2A02;  
              glyph = "⨂";  
              name="n-ary circled times operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryCoproductPrefix = 
             {character = Unicode 0x2210;  
              glyph = "∐";  
              name="n-ary coproduct";  
              form = Prefix;  
              priority = 350;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryIntersectionPrefix = 
             {character = Unicode 0x22C2;  
              glyph = "⋂";  
              name="n-ary intersection";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryLogicalAndPrefix = 
             {character = Unicode 0x22C0;  
              glyph = "⋀";  
              name="n-ary logical and";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryLogicalOrPrefix = 
             {character = Unicode 0x22C1;  
              glyph = "⋁";  
              name="n-ary logical or";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryProductPrefix = 
             {character = Unicode 0x220F;  
              glyph = "∏";  
              name="n-ary product";  
              form = Prefix;  
              priority = 350;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nArySquareIntersectionOperatorPrefix = 
             {character = Unicode 0x2A05;  
              glyph = "⨅";  
              name="n-ary square intersection operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nArySquareUnionOperatorPrefix = 
             {character = Unicode 0x2A06;  
              glyph = "⨆";  
              name="n-ary square union operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nArySummationPrefix = 
             {character = Unicode 0x2211;  
              glyph = "∑";  
              name="n-ary summation";  
              form = Prefix;  
              priority = 290;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryTimesOperatorPrefix = 
             {character = Unicode 0x2A09;  
              glyph = "⨉";  
              name="n-ary times operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryUnionOperatorWithDotPrefix = 
             {character = Unicode 0x2A03;  
              glyph = "⨃";  
              name="n-ary union operator with dot";  
              form = Prefix;  
              priority = 320;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryUnionOperatorWithPlusPrefix = 
             {character = Unicode 0x2A04;  
              glyph = "⨄";  
              name="n-ary union operator with plus";  
              form = Prefix;  
              priority = 320;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryUnionPrefix = 
             {character = Unicode 0x22C3;  
              glyph = "⋃";  
              name="n-ary union";  
              form = Prefix;  
              priority = 320;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let nAryWhiteVerticalBarPrefix = 
             {character = Unicode 0x2AFF;  
              glyph = "⫿";  
              name="n-ary white vertical bar";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let negatedDoubleVerticalBarDoubleRightTurnstileInfix = 
             {character = Unicode 0x22AF;  
              glyph = "⊯";  
              name="negated double vertical bar double right turnstile";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherApproximatelyNorActuallyEqualToInfix = 
             {character = Unicode 0x2247;  
              glyph = "≇";  
              name="neither approximately nor actually equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherASubsetOfNorEqualToInfix = 
             {character = Unicode 0x2288;  
              glyph = "⊈";  
              name="neither a subset of nor equal to";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherASupersetOfNorEqualToInfix = 
             {character = Unicode 0x2289;  
              glyph = "⊉";  
              name="neither a superset of nor equal to";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherGreaterThanNorEqualToInfix = 
             {character = Unicode 0x2271;  
              glyph = "≱";  
              name="neither greater-than nor equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherGreaterThanNorEquivalentToInfix = 
             {character = Unicode 0x2275;  
              glyph = "≵";  
              name="neither greater-than nor equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherGreaterThanNorLessThanInfix = 
             {character = Unicode 0x2279;  
              glyph = "≹";  
              name="neither greater-than nor less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherLessThanNorEqualToInfix = 
             {character = Unicode 0x2270;  
              glyph = "≰";  
              name="neither less-than nor equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherLessThanNorEquivalentToInfix = 
             {character = Unicode 0x2274;  
              glyph = "≴";  
              name="neither less-than nor equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let neitherLessThanNorGreaterThanInfix = 
             {character = Unicode 0x2278;  
              glyph = "≸";  
              name="neither less-than nor greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let nonforkingInfix = 
             {character = Unicode 0x2ADD;  
              glyph = "⫝";  
              name="nonforking";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let nonforkingWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2ADD;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⫝̸";  
              name="nonforking with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let norInfix = 
             {character = Unicode 0x22BD;  
              glyph = "⊽";  
              name="nor";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let normalSubgroupOfInfix = 
             {character = Unicode 0x22B2;  
              glyph = "⊲";  
              name="normal subgroup of";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let normalSubgroupOfOrEqualToInfix = 
             {character = Unicode 0x22B4;  
              glyph = "⊴";  
              name="normal subgroup of or equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northEastAndSouthWestArrowInfix = 
             {character = Unicode 0x2922;  
              glyph = "⤢";  
              name="north east and south west arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let northEastArrowAndSouthEastArrowInfix = 
             {character = Unicode 0x2928;  
              glyph = "⤨";  
              name="north east arrow and south east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northEastArrowCrossingNorthWestArrowInfix = 
             {character = Unicode 0x2931;  
              glyph = "⤱";  
              name="north east arrow crossing north west arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northEastArrowCrossingSouthEastArrowInfix = 
             {character = Unicode 0x292E;  
              glyph = "⤮";  
              name="north east arrow crossing south east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northEastArrowInfix = 
             {character = Unicode 0x2197;  
              glyph = "↗";  
              name="north east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let northEastArrowWithHookInfix = 
             {character = Unicode 0x2924;  
              glyph = "⤤";  
              name="north east arrow with hook";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northEastDoubleArrowInfix = 
             {character = Unicode 0x21D7;  
              glyph = "⇗";  
              name="north east double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let northWestAndSouthEastArrowInfix = 
             {character = Unicode 0x2921;  
              glyph = "⤡";  
              name="north west and south east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let northWestArrowAndNorthEastArrowInfix = 
             {character = Unicode 0x2927;  
              glyph = "⤧";  
              name="north west arrow and north east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northWestArrowCrossingNorthEastArrowInfix = 
             {character = Unicode 0x2932;  
              glyph = "⤲";  
              name="north west arrow crossing north east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northWestArrowInfix = 
             {character = Unicode 0x2196;  
              glyph = "↖";  
              name="north west arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let northWestArrowToCornerInfix = 
             {character = Unicode 0x21F1;  
              glyph = "⇱";  
              name="north west arrow to corner";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northWestArrowToLongBarInfix = 
             {character = Unicode 0x21B8;  
              glyph = "↸";  
              name="north west arrow to long bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northWestArrowWithHookInfix = 
             {character = Unicode 0x2923;  
              glyph = "⤣";  
              name="north west arrow with hook";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let northWestDoubleArrowInfix = 
             {character = Unicode 0x21D6;  
              glyph = "⇖";  
              name="north west double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let notAlmostEqualToInfix = 
             {character = Unicode 0x2249;  
              glyph = "≉";  
              name="not almost equal to";  
              form = Infix;  
              priority = 250;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notAnElementOfInfix = 
             {character = Unicode 0x2209;  
              glyph = "∉";  
              name="not an element of";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notASubsetOfInfix = 
             {character = Unicode 0x2284;  
              glyph = "⊄";  
              name="not a subset of";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notASupersetOfInfix = 
             {character = Unicode 0x2285;  
              glyph = "⊅";  
              name="not a superset of";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notAsymptoticallyEqualToInfix = 
             {character = Unicode 0x2244;  
              glyph = "≄";  
              name="not asymptotically equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notEqualToInfix = 
             {character = Unicode 0x2260;  
              glyph = "≠";  
              name="not equal to";  
              form = Infix;  
              priority = 255;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notEquivalentToInfix = 
             {character = Unicode 0x226D;  
              glyph = "≭";  
              name="not equivalent to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notGreaterThanInfix = 
             {character = Unicode 0x226F;  
              glyph = "≯";  
              name="not greater-than";  
              form = Infix;  
              priority = 244;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notIdenticalToInfix = 
             {character = Unicode 0x2262;  
              glyph = "≢";  
              name="not identical to";  
              form = Infix;  
              priority = 252;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notLessThanInfix = 
             {character = Unicode 0x226E;  
              glyph = "≮";  
              name="not less-than";  
              form = Infix;  
              priority = 246;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notNormalSubgroupOfInfix = 
             {character = Unicode 0x22EA;  
              glyph = "⋪";  
              name="not normal subgroup of";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notNormalSubgroupOfOrEqualToInfix = 
             {character = Unicode 0x22EC;  
              glyph = "⋬";  
              name="not normal subgroup of or equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notParallelToInfix = 
             {character = Unicode 0x2226;  
              glyph = "∦";  
              name="not parallel to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notSignPrefix = 
             {character = Unicode 0xAC;  
              glyph = "¬";  
              name="not sign";  
              form = Prefix;  
              priority = 680;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let notSquareImageOfOrEqualToInfix = 
             {character = Unicode 0x22E2;  
              glyph = "⋢";  
              name="not square image of or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notSquareOriginalOfOrEqualToInfix = 
             {character = Unicode 0x22E3;  
              glyph = "⋣";  
              name="not square original of or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notTildeInfix = 
             {character = Unicode 0x2241;  
              glyph = "≁";  
              name="not tilde";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let notTrueInfix = 
             {character = Unicode 0x22AD;  
              glyph = "⊭";  
              name="not true";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let obliqueAngleOpeningDownInfix = 
             {character = Unicode 0x29A7;  
              glyph = "⦧";  
              name="oblique angle opening down";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let obliqueAngleOpeningUpInfix = 
             {character = Unicode 0x29A6;  
              glyph = "⦦";  
              name="oblique angle opening up";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let originalOfInfix = 
             {character = Unicode 0x22B6;  
              glyph = "⊶";  
              name="original of";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let overlinePostfix = 
             {character = Unicode 0x203E;  
              glyph = "‾";  
              name="overline";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let parallelToInfix = 
             {character = Unicode 0x2225;  
              glyph = "∥";  
              name="parallel to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let parallelWithHorizontalStrokeInfix = 
             {character = Unicode 0x2AF2;  
              glyph = "⫲";  
              name="parallel with horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let parallelWithTildeOperatorInfix = 
             {character = Unicode 0x2AF3;  
              glyph = "⫳";  
              name="parallel with tilde operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let partialDifferentialPrefix = 
             {character = Unicode 0x2202;  
              glyph = "∂";  
              name="partial differential";  
              form = Prefix;  
              priority = 740;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let percentSignInfix = 
             {character = Char  '%';  
              glyph = "%";  
              name="percent sign";  
              form = Infix;  
              priority = 640;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let perpendicularWithSInfix = 
             {character = Unicode 0x2AE1;  
              glyph = "⫡";  
              name="perpendicular with s";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let pitchforkInfix = 
             {character = Unicode 0x22D4;  
              glyph = "⋔";  
              name="pitchfork";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let pitchforkWithTeeTopInfix = 
             {character = Unicode 0x2ADA;  
              glyph = "⫚";  
              name="pitchfork with tee top";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let plusMinusSignInfix = 
             {character = Unicode 0xB1;  
              glyph = "±";  
              name="plus-minus sign";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusMinusSignPrefix = 
             {character = Unicode 0xB1;  
              glyph = "±";  
              name="plus-minus sign";  
              form = Prefix;  
              priority = 275;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let plusSignAboveEqualsSignInfix = 
             {character = Unicode 0x2A72;  
              glyph = "⩲";  
              name="plus sign above equals sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignInfix = 
             {character = Char  '+';  
              glyph = "+";  
              name="plus sign";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignInLeftHalfCircleInfix = 
             {character = Unicode 0x2A2D;  
              glyph = "⨭";  
              name="plus sign in left half circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignInRightHalfCircleInfix = 
             {character = Unicode 0x2A2E;  
              glyph = "⨮";  
              name="plus sign in right half circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignInTriangleInfix = 
             {character = Unicode 0x2A39;  
              glyph = "⨹";  
              name="plus sign in triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignPrefix = 
             {character = Char  '+';  
              glyph = "+";  
              name="plus sign";  
              form = Prefix;  
              priority = 275;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let plusSignWithBlackTriangleInfix = 
             {character = Unicode 0x2A28;  
              glyph = "⨨";  
              name="plus sign with black triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignWithCircumflexAccentAboveInfix = 
             {character = Unicode 0x2A23;  
              glyph = "⨣";  
              name="plus sign with circumflex accent above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignWithDotBelowInfix = 
             {character = Unicode 0x2A25;  
              glyph = "⨥";  
              name="plus sign with dot below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignWithSmallCircleAboveInfix = 
             {character = Unicode 0x2A22;  
              glyph = "⨢";  
              name="plus sign with small circle above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignWithSubscriptTwoInfix = 
             {character = Unicode 0x2A27;  
              glyph = "⨧";  
              name="plus sign with subscript two";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignWithTildeAboveInfix = 
             {character = Unicode 0x2A24;  
              glyph = "⨤";  
              name="plus sign with tilde above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let plusSignWithTildeBelowInfix = 
             {character = Unicode 0x2A26;  
              glyph = "⨦";  
              name="plus sign with tilde below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let precedesAboveAlmostEqualToInfix = 
             {character = Unicode 0x2AB7;  
              glyph = "⪷";  
              name="precedes above almost equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesAboveEqualsSignInfix = 
             {character = Unicode 0x2AB3;  
              glyph = "⪳";  
              name="precedes above equals sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesAboveNotAlmostEqualToInfix = 
             {character = Unicode 0x2AB9;  
              glyph = "⪹";  
              name="precedes above not almost equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesAboveNotEqualToInfix = 
             {character = Unicode 0x2AB5;  
              glyph = "⪵";  
              name="precedes above not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesAboveSingleLineEqualsSignInfix = 
             {character = Unicode 0x2AAF;  
              glyph = "⪯";  
              name="precedes above single-line equals sign";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesAboveSingleLineEqualsSignWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2AAF;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⪯̸";  
              name="precedes above single-line equals sign with slash";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesAboveSingleLineNotEqualToInfix = 
             {character = Unicode 0x2AB1;  
              glyph = "⪱";  
              name="precedes above single-line not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesButNotEquivalentToInfix = 
             {character = Unicode 0x22E8;  
              glyph = "⋨";  
              name="precedes but not equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesInfix = 
             {character = Unicode 0x227A;  
              glyph = "≺";  
              name="precedes";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesOrEqualToInfix = 
             {character = Unicode 0x227C;  
              glyph = "≼";  
              name="precedes or equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesOrEquivalentToInfix = 
             {character = Unicode 0x227E;  
              glyph = "≾";  
              name="precedes or equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let precedesUnderRelationInfix = 
             {character = Unicode 0x22B0;  
              glyph = "⊰";  
              name="precedes under relation";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let primePostfix = 
             {character = Unicode 0x2032;  
              glyph = "′";  
              name="prime";  
              form = Postfix;  
              priority = 800;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let proportionalToInfix = 
             {character = Unicode 0x221D;  
              glyph = "∝";  
              name="proportional to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let proportionInfix = 
             {character = Unicode 0x2237;  
              glyph = "∷";  
              name="proportion";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let quadrupleIntegralOperatorPrefix = 
             {character = Unicode 0x2A0C;  
              glyph = "⨌";  
              name="quadruple integral operator";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let quadruplePrimePostfix = 
             {character = Unicode 0x2057;  
              glyph = "⁗";  
              name="quadruple prime";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let quaternionIntegralOperatorPrefix = 
             {character = Unicode 0x2A16;  
              glyph = "⨖";  
              name="quaternion integral operator";  
              form = Prefix;  
              priority = 310;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let questionedEqualToInfix = 
             {character = Unicode 0x225F;  
              glyph = "≟";  
              name="questioned equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let questionMarkInfix = 
             {character = Char  '?';  
              glyph = "?";  
              name="question mark";  
              form = Infix;  
              priority = 835;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let quotationMarkPostfix = 
             {character = Char  '\"';  
              glyph = "\"";  
              name="quotation mark";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let ratioInfix = 
             {character = Unicode 0x2236;  
              glyph = "∶";  
              name="ratio";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let reversedAngleInfix = 
             {character = Unicode 0x29A3;  
              glyph = "⦣";  
              name="reversed angle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let reversedAngleWithUnderbarInfix = 
             {character = Unicode 0x29A5;  
              glyph = "⦥";  
              name="reversed angle with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let reversedDoublePrimePostfix = 
             {character = Unicode 0x2036;  
              glyph = "‶";  
              name="reversed double prime";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let reversedDoubleStrokeNotSignInfix = 
             {character = Unicode 0x2AED;  
              glyph = "⫭";  
              name="reversed double stroke not sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let reversedEmptySetInfix = 
             {character = Unicode 0x29B0;  
              glyph = "⦰";  
              name="reversed empty set";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let reversedPrimePostfix = 
             {character = Unicode 0x2035;  
              glyph = "‵";  
              name="reversed prime";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let reversedTildeEqualsInfix = 
             {character = Unicode 0x22CD;  
              glyph = "⋍";  
              name="reversed tilde equals";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let reversedTildeInfix = 
             {character = Unicode 0x223D;  
              glyph = "∽";  
              name="reversed tilde";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let reversedTildeWithUnderlineInfix = 
             {character = UnicodeArray [|Unicode 0x223D;Unicode 0x0020;Unicode 0x331|];  
              glyph = "∽̱";  
              name="reversed tilde with underline";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let reversedTriplePrimePostfix = 
             {character = Unicode 0x2037;  
              glyph = "‷";  
              name="reversed triple prime";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let reverseSolidusInfix = 
             {character = Char '\\';  
              glyph = @"\";  
              name="reverse solidus";  
              form = Infix;  
              priority = 650;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let reverseSolidusOperatorInfix = 
             {character = Unicode 0x29F5;  
              glyph = "⧵";  
              name="reverse solidus operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let reverseSolidusWithHorizontalStrokeInfix = 
             {character = Unicode 0x29F7;  
              glyph = "⧷";  
              name="reverse solidus with horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let rightAngleBracketWithDotPostfix = 
             {character = Unicode 0x2992;  
              glyph = "⦒";  
              name="right angle bracket with dot";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightAngleInfix = 
             {character = Unicode 0x221F;  
              glyph = "∟";  
              name="right angle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let rightAngleVariantWithSquareInfix = 
             {character = Unicode 0x299C;  
              glyph = "⦜";  
              name="right angle variant with square";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let rightAngleWithArcInfix = 
             {character = Unicode 0x22BE;  
              glyph = "⊾";  
              name="right angle with arc";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let rightArcGreaterThanBracketPostfix = 
             {character = Unicode 0x2994;  
              glyph = "⦔";  
              name="right arc greater-than bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightArrowWithSmallCircleInfix = 
             {character = Unicode 0x21F4;  
              glyph = "⇴";  
              name="right arrow with small circle";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightBlackTortoiseShellBracketPostfix = 
             {character = Unicode 0x2998;  
              glyph = "⦘";  
              name="right black tortoise shell bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightCeilingPostfix = 
             {character = Unicode 0x2309;  
              glyph = "⌉";  
              name="right ceiling";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightCurlyBracketPostfix = 
             {character = Char  '}';  
              glyph = "}";  
              name="right curly bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightDoubleArrowWithRoundedHeadInfix = 
             {character = Unicode 0x2970;  
              glyph = "⥰";  
              name="right double arrow with rounded head";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightDoubleQuotationMarkPostfix = 
             {character = Unicode 0x201D;  
              glyph = "”";  
              name="right double quotation mark";  
              form = Postfix;  
              priority = 10;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true]}
        let rightDoubleWigglyFenceInfix = 
             {character = Unicode 0x29DB;  
              glyph = "⧛";  
              name="right double wiggly fence";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let rightFishTailInfix = 
             {character = Unicode 0x297D;  
              glyph = "⥽";  
              name="right fish tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightFloorPostfix = 
             {character = Unicode 0x230B;  
              glyph = "⌋";  
              name="right floor";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightHalfBlackCircleInfix = 
             {character = Unicode 0x25D7;  
              glyph = "◗";  
              name="right half black circle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let righthandInteriorProductInfix = 
             {character = Unicode 0x2A3D;  
              glyph = "⨽";  
              name="righthand interior product";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let rightNormalFactorSemidirectProductInfix = 
             {character = Unicode 0x22CA;  
              glyph = "⋊";  
              name="right normal factor semidirect product";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let rightParenthesisPostfix = 
             {character = Char  ')';  
              glyph = ")";  
              name="right parenthesis";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightPointingAngleBracketPostfix = 
             {character = Unicode 0x232A;  
              glyph = "〉";  
              name="right-pointing angle bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightPointingCurvedAngleBracketPostfix = 
             {character = Unicode 0x29FD;  
              glyph = "⧽";  
              name="right-pointing curved angle bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightSemidirectProductInfix = 
             {character = Unicode 0x22CC;  
              glyph = "⋌";  
              name="right semidirect product";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let rightSideArcClockwiseArrowInfix = 
             {character = Unicode 0x2938;  
              glyph = "⤸";  
              name="right-side arc clockwise arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let rightSingleQuotationMarkPostfix = 
             {character = Unicode 0x2019;  
              glyph = "’";  
              name="right single quotation mark";  
              form = Postfix;  
              priority = 10;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true]}
        let rightSquareBracketPostfix = 
             {character = Char  ']';  
              glyph = "]";  
              name="right square bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightSquareBracketWithTickInBottomCornerPostfix = 
             {character = Unicode 0x298E;  
              glyph = "⦎";  
              name="right square bracket with tick in bottom corner";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightSquareBracketWithTickInTopCornerPostfix = 
             {character = Unicode 0x2990;  
              glyph = "⦐";  
              name="right square bracket with tick in top corner";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightSquareBracketWithUnderbarPostfix = 
             {character = Unicode 0x298C;  
              glyph = "⦌";  
              name="right square bracket with underbar";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightTackInfix = 
             {character = Unicode 0x22A2;  
              glyph = "⊢";  
              name="right tack";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let rightTriangleAboveLeftTriangleInfix = 
             {character = Unicode 0x29CE;  
              glyph = "⧎";  
              name="right triangle above left triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let rightTriangleInfix = 
             {character = Unicode 0x22BF;  
              glyph = "⊿";  
              name="right triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let rightwardsArrowAboveAlmostEqualToInfix = 
             {character = Unicode 0x2975;  
              glyph = "⥵";  
              name="rightwards arrow above almost equal to";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowAboveShortLeftwardsArrowInfix = 
             {character = Unicode 0x2942;  
              glyph = "⥂";  
              name="rightwards arrow above short leftwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowAboveTildeOperatorInfix = 
             {character = Unicode 0x2974;  
              glyph = "⥴";  
              name="rightwards arrow above tilde operator";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowFromBarInfix = 
             {character = Unicode 0x21A6;  
              glyph = "↦";  
              name="rightwards arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsArrowFromBarToBlackDiamondInfix = 
             {character = Unicode 0x2920;  
              glyph = "⤠";  
              name="rightwards arrow from bar to black diamond";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowInfix = 
             {character = Unicode 0x2192;  
              glyph = "→";  
              name="rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsArrowOverLeftwardsArrowInfix = 
             {character = Unicode 0x21C4;  
              glyph = "⇄";  
              name="rightwards arrow over leftwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsArrowTailInfix = 
             {character = Unicode 0x291A;  
              glyph = "⤚";  
              name="rightwards arrow-tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowThroughXInfix = 
             {character = Unicode 0x2947;  
              glyph = "⥇";  
              name="rightwards arrow through x";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowToBarInfix = 
             {character = Unicode 0x21E5;  
              glyph = "⇥";  
              name="rightwards arrow to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsArrowToBlackDiamondInfix = 
             {character = Unicode 0x291E;  
              glyph = "⤞";  
              name="rightwards arrow to black diamond";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowWithCornerDownwardsInfix = 
             {character = Unicode 0x21B4;  
              glyph = "↴";  
              name="rightwards arrow with corner downwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let rightwardsArrowWithDottedStemInfix = 
             {character = Unicode 0x2911;  
              glyph = "⤑";  
              name="rightwards arrow with dotted stem";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowWithDoubleVerticalStrokeInfix = 
             {character = Unicode 0x21FB;  
              glyph = "⇻";  
              name="rightwards arrow with double vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowWithHookInfix = 
             {character = Unicode 0x21AA;  
              glyph = "↪";  
              name="rightwards arrow with hook";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsArrowWithLoopInfix = 
             {character = Unicode 0x21AC;  
              glyph = "↬";  
              name="rightwards arrow with loop";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsArrowWithPlusBelowInfix = 
             {character = Unicode 0x2945;  
              glyph = "⥅";  
              name="rightwards arrow with plus below";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowWithStrokeInfix = 
             {character = Unicode 0x219B;  
              glyph = "↛";  
              name="rightwards arrow with stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowWithTailInfix = 
             {character = Unicode 0x21A3;  
              glyph = "↣";  
              name="rightwards arrow with tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsArrowWithTailWithDoubleVerticalStrokeInfix = 
             {character = Unicode 0x2915;  
              glyph = "⤕";  
              name="rightwards arrow with tail with double vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowWithTailWithVerticalStrokeInfix = 
             {character = Unicode 0x2914;  
              glyph = "⤔";  
              name="rightwards arrow with tail with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsArrowWithVerticalStrokeInfix = 
             {character = Unicode 0x21F8;  
              glyph = "⇸";  
              name="rightwards arrow with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsDashedArrowInfix = 
             {character = Unicode 0x21E2;  
              glyph = "⇢";  
              name="rightwards dashed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsDoubleArrowFromBarInfix = 
             {character = Unicode 0x2907;  
              glyph = "⤇";  
              name="rightwards double arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsDoubleArrowInfix = 
             {character = Unicode 0x21D2;  
              glyph = "⇒";  
              name="rightwards double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsDoubleArrowTailInfix = 
             {character = Unicode 0x291C;  
              glyph = "⤜";  
              name="rightwards double arrow-tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsDoubleArrowWithStrokeInfix = 
             {character = Unicode 0x21CF;  
              glyph = "⇏";  
              name="rightwards double arrow with stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsDoubleArrowWithVerticalStrokeInfix = 
             {character = Unicode 0x2903;  
              glyph = "⤃";  
              name="rightwards double arrow with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsDoubleDashArrowInfix = 
             {character = Unicode 0x290D;  
              glyph = "⤍";  
              name="rightwards double dash arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsHarpoonOverLeftwardsHarpoonInfix = 
             {character = Unicode 0x21CC;  
              glyph = "⇌";  
              name="rightwards harpoon over leftwards harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsHarpoonWithBarbDownAboveLeftwardsHarpoonWithBarbDownInfix = 
             {character = Unicode 0x2969;  
              glyph = "⥩";  
              name="rightwards harpoon with barb down above leftwards harpoon with barb down";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsHarpoonWithBarbDownBelowLongDashInfix = 
             {character = Unicode 0x296D;  
              glyph = "⥭";  
              name="rightwards harpoon with barb down below long dash";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsHarpoonWithBarbDownFromBarInfix = 
             {character = Unicode 0x295F;  
              glyph = "⥟";  
              name="rightwards harpoon with barb down from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsHarpoonWithBarbDownToBarInfix = 
             {character = Unicode 0x2957;  
              glyph = "⥗";  
              name="rightwards harpoon with barb down to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let rightwardsHarpoonWithBarbDownwardsInfix = 
             {character = Unicode 0x21C1;  
              glyph = "⇁";  
              name="rightwards harpoon with barb downwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsHarpoonWithBarbUpAboveLeftwardsHarpoonWithBarbUpInfix = 
             {character = Unicode 0x2968;  
              glyph = "⥨";  
              name="rightwards harpoon with barb up above leftwards harpoon with barb up";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsHarpoonWithBarbUpAboveLongDashInfix = 
             {character = Unicode 0x296C;  
              glyph = "⥬";  
              name="rightwards harpoon with barb up above long dash";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsHarpoonWithBarbUpAboveRightwardsHarpoonWithBarbDownInfix = 
             {character = Unicode 0x2964;  
              glyph = "⥤";  
              name="rightwards harpoon with barb up above rightwards harpoon with barb down";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsHarpoonWithBarbUpFromBarInfix = 
             {character = Unicode 0x295B;  
              glyph = "⥛";  
              name="rightwards harpoon with barb up from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsHarpoonWithBarbUpToBarInfix = 
             {character = Unicode 0x2953;  
              glyph = "⥓";  
              name="rightwards harpoon with barb up to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsHarpoonWithBarbUpwardsInfix = 
             {character = Unicode 0x21C0;  
              glyph = "⇀";  
              name="rightwards harpoon with barb upwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsOpenHeadedArrowInfix = 
             {character = Unicode 0x21FE;  
              glyph = "⇾";  
              name="rightwards open-headed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsPairedArrowsInfix = 
             {character = Unicode 0x21C9;  
              glyph = "⇉";  
              name="rightwards paired arrows";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsQuadrupleArrowInfix = 
             {character = Unicode 0x2B46;  
              glyph = "⭆";  
              name="rightwards quadruple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let rightwardsSquiggleArrowInfix = 
             {character = Unicode 0x21DD;  
              glyph = "⇝";  
              name="rightwards squiggle arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsTripleArrowInfix = 
             {character = Unicode 0x21DB;  
              glyph = "⇛";  
              name="rightwards triple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsTripleDashArrowInfix = 
             {character = Unicode 0x290F;  
              glyph = "⤏";  
              name="rightwards triple dash arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsTwoHeadedArrowFromBarInfix = 
             {character = Unicode 0x2905;  
              glyph = "⤅";  
              name="rightwards two-headed arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsTwoHeadedArrowInfix = 
             {character = Unicode 0x21A0;  
              glyph = "↠";  
              name="rightwards two headed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsTwoHeadedArrowWithDoubleVerticalStrokeInfix = 
             {character = Unicode 0x2901;  
              glyph = "⤁";  
              name="rightwards two-headed arrow with double vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsTwoHeadedArrowWithTailInfix = 
             {character = Unicode 0x2916;  
              glyph = "⤖";  
              name="rightwards two-headed arrow with tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsTwoHeadedArrowWithTailWithDoubleVerticalStrokeInfix = 
             {character = Unicode 0x2918;  
              glyph = "⤘";  
              name="rightwards two-headed arrow with tail with double vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsTwoHeadedArrowWithTailWithVerticalStrokeInfix = 
             {character = Unicode 0x2917;  
              glyph = "⤗";  
              name="rightwards two-headed arrow with tail with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsTwoHeadedArrowWithVerticalStrokeInfix = 
             {character = Unicode 0x2900;  
              glyph = "⤀";  
              name="rightwards two-headed arrow with vertical stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let rightwardsTwoHeadedTripleDashArrowInfix = 
             {character = Unicode 0x2910;  
              glyph = "⤐";  
              name="rightwards two-headed triple dash arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsWaveArrowInfix = 
             {character = Unicode 0x219D;  
              glyph = "↝";  
              name="rightwards wave arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsWhiteArrowFromWallInfix = 
             {character = Unicode 0x21F0;  
              glyph = "⇰";  
              name="rightwards white arrow from wall";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightwardsWhiteArrowInfix = 
             {character = Unicode 0x21E8;  
              glyph = "⇨";  
              name="rightwards white arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let rightWhiteCurlyBracketPostfix = 
             {character = Unicode 0x2984;  
              glyph = "⦄";  
              name="right white curly bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightWhiteParenthesisPostfix = 
             {character = Unicode 0x2986;  
              glyph = "⦆";  
              name="right white parenthesis";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let rightWigglyFenceInfix = 
             {character = Unicode 0x29D9;  
              glyph = "⧙";  
              name="right wiggly fence";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let ringAbovePostfix = 
             {character = Unicode 0x2DA;  
              glyph = "˚";  
              name="ring above";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let ringEqualToInfix = 
             {character = Unicode 0x2257;  
              glyph = "≗";  
              name="ring equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let ringInEqualToInfix = 
             {character = Unicode 0x2256;  
              glyph = "≖";  
              name="ring in equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let ringOperatorInfix = 
             {character = Unicode 0x2218;  
              glyph = "∘";  
              name="ring operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let risingDiagonalCrossingFallingDiagonalInfix = 
             {character = Unicode 0x292B;  
              glyph = "⤫";  
              name="rising diagonal crossing falling diagonal";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let risingDiagonalCrossingSouthEastArrowInfix = 
             {character = Unicode 0x2930;  
              glyph = "⤰";  
              name="rising diagonal crossing south east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let ruleDelayedInfix = 
             {character = Unicode 0x29F4;  
              glyph = "⧴";  
              name="rule-delayed";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let semicolonInfix = 
             {character = Char  ';';  
              glyph = ";";  
              name="semicolon";  
              form = Infix;  
              priority = 30;  
              lspace= EM 0.<em>;  
              rspace = NamedLength ThinMathSpace;  
              properties=[Separator true; LineBreakStyle  After]}
        let semidirectProductWithBottomClosedInfix = 
             {character = Unicode 0x2A32;  
              glyph = "⨲";  
              name="semidirect product with bottom closed";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let setMinusInfix = 
             {character = Unicode 0x2216;  
              glyph = "∖";  
              name="set minus";  
              form = Infix;  
              priority = 650;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let shortDownTackInfix = 
             {character = Unicode 0x2ADF;  
              glyph = "⫟";  
              name="short down tack";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let shortDownTackWithOverbarInfix = 
             {character = Unicode 0x2AE7;  
              glyph = "⫧";  
              name="short down tack with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let shortLeftTackInfix = 
             {character = Unicode 0x2ADE;  
              glyph = "⫞";  
              name="short left tack";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let shortRightwardsArrowAboveLeftwardsArrowInfix = 
             {character = Unicode 0x2944;  
              glyph = "⥄";  
              name="short rightwards arrow above leftwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let shortUpTackAboveShortDownTackInfix = 
             {character = Unicode 0x2AE9;  
              glyph = "⫩";  
              name="short up tack above short down tack";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let shortUpTackInfix = 
             {character = Unicode 0x2AE0;  
              glyph = "⫠";  
              name="short up tack";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let shortUpTackWithUnderbarInfix = 
             {character = Unicode 0x2AE8;  
              glyph = "⫨";  
              name="short up tack with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let shuffleProductInfix = 
             {character = Unicode 0x29E2;  
              glyph = "⧢";  
              name="shuffle product";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let similarAboveGreaterThanAboveEqualsSignInfix = 
             {character = Unicode 0x2AA0;  
              glyph = "⪠";  
              name="similar above greater-than above equals sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let similarAboveLessThanAboveEqualsSignInfix = 
             {character = Unicode 0x2A9F;  
              glyph = "⪟";  
              name="similar above less-than above equals sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let similarMinusSimilarInfix = 
             {character = Unicode 0x2A6C;  
              glyph = "⩬";  
              name="similar minus similar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let similarOrGreaterThanInfix = 
             {character = Unicode 0x2A9E;  
              glyph = "⪞";  
              name="similar or greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let similarOrLessThanInfix = 
             {character = Unicode 0x2A9D;  
              glyph = "⪝";  
              name="similar or less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let sineWaveInfix = 
             {character = Unicode 0x223F;  
              glyph = "∿";  
              name="sine wave";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let singleHighReversed9QuotationMarkPostfix = 
             {character = Unicode 0x201B;  
              glyph = "‛";  
              name="single high-reversed-9 quotation mark";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let singleLow9QuotationMarkPostfix = 
             {character = Unicode 0x201A;  
              glyph = "‚";  
              name="single low-9 quotation mark";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let sInTriangleInfix = 
             {character = Unicode 0x29CC;  
              glyph = "⧌";  
              name="s in triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let slantedEqualToOrGreaterThanInfix = 
             {character = Unicode 0x2A96;  
              glyph = "⪖";  
              name="slanted equal to or greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let slantedEqualToOrGreaterThanWithDotInsideInfix = 
             {character = Unicode 0x2A98;  
              glyph = "⪘";  
              name="slanted equal to or greater-than with dot inside";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let slantedEqualToOrLessThanInfix = 
             {character = Unicode 0x2A95;  
              glyph = "⪕";  
              name="slanted equal to or less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let slantedEqualToOrLessThanWithDotInsideInfix = 
             {character = Unicode 0x2A97;  
              glyph = "⪗";  
              name="slanted equal to or less-than with dot inside";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let slopingLargeAndInfix = 
             {character = Unicode 0x2A58;  
              glyph = "⩘";  
              name="sloping large and";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let slopingLargeOrInfix = 
             {character = Unicode 0x2A57;  
              glyph = "⩗";  
              name="sloping large or";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let smallContainsAsMemberInfix = 
             {character = Unicode 0x220D;  
              glyph = "∍";  
              name="small contains as member";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallContainsWithOverbarInfix = 
             {character = Unicode 0x22FE;  
              glyph = "⋾";  
              name="small contains with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallContainsWithVerticalBarAtEndOfHorizontalStrokeInfix = 
             {character = Unicode 0x22FC;  
              glyph = "⋼";  
              name="small contains with vertical bar at end of horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallElementOfInfix = 
             {character = Unicode 0x220A;  
              glyph = "∊";  
              name="small element of";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallElementOfWithOverbarInfix = 
             {character = Unicode 0x22F7;  
              glyph = "⋷";  
              name="small element of with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallElementOfWithVerticalBarAtEndOfHorizontalStrokeInfix = 
             {character = Unicode 0x22F4;  
              glyph = "⋴";  
              name="small element of with vertical bar at end of horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallerThanInfix = 
             {character = Unicode 0x2AAA;  
              glyph = "⪪";  
              name="smaller than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallerThanOrEqualToInfix = 
             {character = Unicode 0x2AAC;  
              glyph = "⪬";  
              name="smaller than or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let smallTildePostfix = 
             {character = Unicode 0x2DC;  
              glyph = "˜";  
              name="small tilde";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let smallVeeWithUnderbarInfix = 
             {character = Unicode 0x2A61;  
              glyph = "⩡";  
              name="small vee with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let smashProductInfix = 
             {character = Unicode 0x2A33;  
              glyph = "⨳";  
              name="smash product";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let solidusInfix = 
             {character = Char  '/';  
              glyph = "/";  
              name="solidus";  
              form = Infix;  
              priority = 660;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let solidusWithOverbarInfix = 
             {character = Unicode 0x29F6;  
              glyph = "⧶";  
              name="solidus with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let southEastArrowAndSouthWestArrowInfix = 
             {character = Unicode 0x2929;  
              glyph = "⤩";  
              name="south east arrow and south west arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let southEastArrowCrossingNorthEastArrowInfix = 
             {character = Unicode 0x292D;  
              glyph = "⤭";  
              name="south east arrow crossing north east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let southEastArrowInfix = 
             {character = Unicode 0x2198;  
              glyph = "↘";  
              name="south east arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let southEastArrowToCornerInfix = 
             {character = Unicode 0x21F2;  
              glyph = "⇲";  
              name="south east arrow to corner";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let southEastArrowWithHookInfix = 
             {character = Unicode 0x2925;  
              glyph = "⤥";  
              name="south east arrow with hook";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let southEastDoubleArrowInfix = 
             {character = Unicode 0x21D8;  
              glyph = "⇘";  
              name="south east double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let southWestArrowAndNorthWestArrowInfix = 
             {character = Unicode 0x292A;  
              glyph = "⤪";  
              name="south west arrow and north west arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let southWestArrowInfix = 
             {character = Unicode 0x2199;  
              glyph = "↙";  
              name="south west arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let southWestArrowWithHookInfix = 
             {character = Unicode 0x2926;  
              glyph = "⤦";  
              name="south west arrow with hook";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let southWestDoubleArrowInfix = 
             {character = Unicode 0x21D9;  
              glyph = "⇙";  
              name="south west double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let sphericalAngleOpeningLeftInfix = 
             {character = Unicode 0x29A0;  
              glyph = "⦠";  
              name="spherical angle opening left";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let sphericalAngleOpeningUpInfix = 
             {character = Unicode 0x29A1;  
              glyph = "⦡";  
              name="spherical angle opening up";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let sphericalAnglePrefix = 
             {character = Unicode 0x2222;  
              glyph = "∢";  
              name="spherical angle";  
              form = Prefix;  
              priority = 670;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[]}
        let squareCapInfix = 
             {character = Unicode 0x2293;  
              glyph = "⊓";  
              name="square cap";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squareCupInfix = 
             {character = Unicode 0x2294;  
              glyph = "⊔";  
              name="square cup";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredAsteriskInfix = 
             {character = Unicode 0x29C6;  
              glyph = "⧆";  
              name="squared asterisk";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredDotOperatorInfix = 
             {character = Unicode 0x22A1;  
              glyph = "⊡";  
              name="squared dot operator";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredFallingDiagonalSlashInfix = 
             {character = Unicode 0x29C5;  
              glyph = "⧅";  
              name="squared falling diagonal slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredMinusInfix = 
             {character = Unicode 0x229F;  
              glyph = "⊟";  
              name="squared minus";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredPlusInfix = 
             {character = Unicode 0x229E;  
              glyph = "⊞";  
              name="squared plus";  
              form = Infix;  
              priority = 275;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredRisingDiagonalSlashInfix = 
             {character = Unicode 0x29C4;  
              glyph = "⧄";  
              name="squared rising diagonal slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredSmallCircleInfix = 
             {character = Unicode 0x29C7;  
              glyph = "⧇";  
              name="squared small circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredSquareInfix = 
             {character = Unicode 0x29C8;  
              glyph = "⧈";  
              name="squared square";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squaredTimesInfix = 
             {character = Unicode 0x22A0;  
              glyph = "⊠";  
              name="squared times";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let squareImageOfInfix = 
             {character = Unicode 0x228F;  
              glyph = "⊏";  
              name="square image of";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareImageOfOrEqualToInfix = 
             {character = Unicode 0x2291;  
              glyph = "⊑";  
              name="square image of or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareImageOfOrNotEqualToInfix = 
             {character = Unicode 0x22E4;  
              glyph = "⋤";  
              name="square image of or not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareImageOfWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x228F;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⊏̸";  
              name="square image of with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareLeftOpenBoxOperatorInfix = 
             {character = Unicode 0x2ACD;  
              glyph = "⫍";  
              name="square left open box operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareOriginalOfInfix = 
             {character = Unicode 0x2290;  
              glyph = "⊐";  
              name="square original of";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareOriginalOfOrEqualToInfix = 
             {character = Unicode 0x2292;  
              glyph = "⊒";  
              name="square original of or equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareOriginalOfOrNotEqualToInfix = 
             {character = Unicode 0x22E5;  
              glyph = "⋥";  
              name="square original of or not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareOriginalOfWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2290;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⊐̸";  
              name="square original of with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareRightOpenBoxOperatorInfix = 
             {character = Unicode 0x2ACE;  
              glyph = "⫎";  
              name="square right open box operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let squareRootPrefix = 
             {character = Unicode 0x221A;  
              glyph = "√";  
              name="square root";  
              form = Prefix;  
              priority = 845;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[Stretchy true]}
        let squareWithContouredOutlineInfix = 
             {character = Unicode 0x29E0;  
              glyph = "⧠";  
              name="square with contoured outline";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let starEqualsInfix = 
             {character = Unicode 0x225B;  
              glyph = "≛";  
              name="star equals";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let starOperatorInfix = 
             {character = Unicode 0x22C6;  
              glyph = "⋆";  
              name="star operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let strictlyEquivalentToInfix = 
             {character = Unicode 0x2263;  
              glyph = "≣";  
              name="strictly equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetAboveRightwardsArrowInfix = 
             {character = Unicode 0x2979;  
              glyph = "⥹";  
              name="subset above rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let subsetAboveSubsetInfix = 
             {character = Unicode 0x2AD5;  
              glyph = "⫕";  
              name="subset above subset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetAboveSupersetInfix = 
             {character = Unicode 0x2AD3;  
              glyph = "⫓";  
              name="subset above superset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfAboveAlmostEqualToInfix = 
             {character = Unicode 0x2AC9;  
              glyph = "⫉";  
              name="subset of above almost equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfAboveEqualsSignInfix = 
             {character = Unicode 0x2AC5;  
              glyph = "⫅";  
              name="subset of above equals sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfAboveNotEqualToInfix = 
             {character = Unicode 0x2ACB;  
              glyph = "⫋";  
              name="subset of above not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfAboveTildeOperatorInfix = 
             {character = Unicode 0x2AC7;  
              glyph = "⫇";  
              name="subset of above tilde operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfInfix = 
             {character = Unicode 0x2282;  
              glyph = "⊂";  
              name="subset of";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfOrEqualToInfix = 
             {character = Unicode 0x2286;  
              glyph = "⊆";  
              name="subset of or equal to";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfOrEqualToWithDotAboveInfix = 
             {character = Unicode 0x2AC3;  
              glyph = "⫃";  
              name="subset of or equal to with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfWithNotEqualToInfix = 
             {character = Unicode 0x228A;  
              glyph = "⊊";  
              name="subset of with not equal to";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetOfWithVerticalLineInfix = 
             {character = UnicodeArray [|Unicode 0x2282;Unicode 0x0020;Unicode 0x20D2|];  
              glyph = "⊂⃒";  
              name="subset of with vertical line";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetWithDotInfix = 
             {character = Unicode 0x2ABD;  
              glyph = "⪽";  
              name="subset with dot";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetWithMultiplicationSignBelowInfix = 
             {character = Unicode 0x2AC1;  
              glyph = "⫁";  
              name="subset with multiplication sign below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let subsetWithPlusSignBelowInfix = 
             {character = Unicode 0x2ABF;  
              glyph = "⪿";  
              name="subset with plus sign below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsAboveAlmostEqualToInfix = 
             {character = Unicode 0x2AB8;  
              glyph = "⪸";  
              name="succeeds above almost equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsAboveEqualsSignInfix = 
             {character = Unicode 0x2AB4;  
              glyph = "⪴";  
              name="succeeds above equals sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsAboveNotAlmostEqualToInfix = 
             {character = Unicode 0x2ABA;  
              glyph = "⪺";  
              name="succeeds above not almost equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsAboveNotEqualToInfix = 
             {character = Unicode 0x2AB6;  
              glyph = "⪶";  
              name="succeeds above not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsAboveSingleLineEqualsSignInfix = 
             {character = Unicode 0x2AB0;  
              glyph = "⪰";  
              name="succeeds above single-line equals sign";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsAboveSingleLineEqualsSignWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x2AB0;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⪰̸";  
              name="succeeds above single-line equals sign with slash";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsAboveSingleLineNotEqualToInfix = 
             {character = Unicode 0x2AB2;  
              glyph = "⪲";  
              name="succeeds above single-line not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsButNotEquivalentToInfix = 
             {character = Unicode 0x22E9;  
              glyph = "⋩";  
              name="succeeds but not equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsInfix = 
             {character = Unicode 0x227B;  
              glyph = "≻";  
              name="succeeds";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsOrEqualToInfix = 
             {character = Unicode 0x227D;  
              glyph = "≽";  
              name="succeeds or equal to";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsOrEquivalentToInfix = 
             {character = Unicode 0x227F;  
              glyph = "≿";  
              name="succeeds or equivalent to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsOrEquivalentToWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x227F;Unicode 0x0020;Unicode 0x338|];  
              glyph = "≿̸";  
              name="succeeds or equivalent to with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let succeedsUnderRelationInfix = 
             {character = Unicode 0x22B1;  
              glyph = "⊱";  
              name="succeeds under relation";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let summationWithIntegralPrefix = 
             {character = Unicode 0x2A0B;  
              glyph = "⨋";  
              name="summation with integral";  
              form = Prefix;  
              priority = 290;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let superscriptOnePostfix = 
             {character = Unicode 0xB9;  
              glyph = "¹";  
              name="superscript one";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let superscriptThreePostfix = 
             {character = Unicode 0xB3;  
              glyph = "³";  
              name="superscript three";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let superscriptTwoPostfix = 
             {character = Unicode 0xB2;  
              glyph = "²";  
              name="superscript two";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let supersetAboveLeftwardsArrowInfix = 
             {character = Unicode 0x297B;  
              glyph = "⥻";  
              name="superset above leftwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let supersetAboveSubsetInfix = 
             {character = Unicode 0x2AD4;  
              glyph = "⫔";  
              name="superset above subset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetAboveSupersetInfix = 
             {character = Unicode 0x2AD6;  
              glyph = "⫖";  
              name="superset above superset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetBesideAndJoinedByDashWithSubsetInfix = 
             {character = Unicode 0x2AD8;  
              glyph = "⫘";  
              name="superset beside and joined by dash with subset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetBesideSubsetInfix = 
             {character = Unicode 0x2AD7;  
              glyph = "⫗";  
              name="superset beside subset";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfAboveAlmostEqualToInfix = 
             {character = Unicode 0x2ACA;  
              glyph = "⫊";  
              name="superset of above almost equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfAboveEqualsSignInfix = 
             {character = Unicode 0x2AC6;  
              glyph = "⫆";  
              name="superset of above equals sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfAboveNotEqualToInfix = 
             {character = Unicode 0x2ACC;  
              glyph = "⫌";  
              name="superset of above not equal to";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfAboveTildeOperatorInfix = 
             {character = Unicode 0x2AC8;  
              glyph = "⫈";  
              name="superset of above tilde operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfInfix = 
             {character = Unicode 0x2283;  
              glyph = "⊃";  
              name="superset of";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfOrEqualToInfix = 
             {character = Unicode 0x2287;  
              glyph = "⊇";  
              name="superset of or equal to";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfOrEqualToWithDotAboveInfix = 
             {character = Unicode 0x2AC4;  
              glyph = "⫄";  
              name="superset of or equal to with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfWithNotEqualToInfix = 
             {character = Unicode 0x228B;  
              glyph = "⊋";  
              name="superset of with not equal to";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetOfWithVerticalLineInfix = 
             {character = UnicodeArray [|Unicode 0x2283;Unicode 0x0020;Unicode 0x20D2|];  
              glyph = "⊃⃒";  
              name="superset of with vertical line";  
              form = Infix;  
              priority = 240;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetWithDotInfix = 
             {character = Unicode 0x2ABE;  
              glyph = "⪾";  
              name="superset with dot";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetWithMultiplicationSignBelowInfix = 
             {character = Unicode 0x2AC2;  
              glyph = "⫂";  
              name="superset with multiplication sign below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let supersetWithPlusSignBelowInfix = 
             {character = Unicode 0x2AC0;  
              glyph = "⫀";  
              name="superset with plus sign below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let surfaceIntegralPrefix = 
             {character = Unicode 0x222F;  
              glyph = "∯";  
              name="surface integral";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let thereDoesNotExistPrefix = 
             {character = Unicode 0x2204;  
              glyph = "∄";  
              name="there does not exist";  
              form = Prefix;  
              priority = 230;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let thereExistsPrefix = 
             {character = Unicode 0x2203;  
              glyph = "∃";  
              name="there exists";  
              form = Prefix;  
              priority = 230;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[]}
        let thereforeInfix = 
             {character = Unicode 0x2234;  
              glyph = "∴";  
              name="therefore";  
              form = Infix;  
              priority = 70;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let thermodynamicInfix = 
             {character = Unicode 0x29E7;  
              glyph = "⧧";  
              name="thermodynamic";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let threeConsecutiveEqualsSignsInfix = 
             {character = Unicode 0x2A76;  
              glyph = "⩶";  
              name="three consecutive equals signs";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let threeRightwardsArrowsInfix = 
             {character = Unicode 0x21F6;  
              glyph = "⇶";  
              name="three rightwards arrows";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let tieOverInfinityInfix = 
             {character = Unicode 0x29DD;  
              glyph = "⧝";  
              name="tie over infinity";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let tildeOperatorAboveRightwardsArrowInfix = 
             {character = Unicode 0x2972;  
              glyph = "⥲";  
              name="tilde operator above rightwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let tildeOperatorInfix = 
             {character = Unicode 0x223C;  
              glyph = "∼";  
              name="tilde operator";  
              form = Infix;  
              priority = 250;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tildeOperatorWithDotAboveInfix = 
             {character = Unicode 0x2A6A;  
              glyph = "⩪";  
              name="tilde operator with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tildeOperatorWithRisingDotsInfix = 
             {character = Unicode 0x2A6B;  
              glyph = "⩫";  
              name="tilde operator with rising dots";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tildePostfix = 
             {character = Char  '~';  
              glyph = "~";  
              name="tilde";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let timesWithLeftHalfBlackInfix = 
             {character = Unicode 0x29D4;  
              glyph = "⧔";  
              name="times with left half black";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let timesWithRightHalfBlackInfix = 
             {character = Unicode 0x29D5;  
              glyph = "⧕";  
              name="times with right half black";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tinyInfix = 
             {character = Unicode 0x29FE;  
              glyph = "⧾";  
              name="tiny";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let topArcAnticlockwiseArrowInfix = 
             {character = Unicode 0x293A;  
              glyph = "⤺";  
              name="top arc anticlockwise arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let topArcAnticlockwiseArrowWithPlusInfix = 
             {character = Unicode 0x293D;  
              glyph = "⤽";  
              name="top arc anticlockwise arrow with plus";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let topArcClockwiseArrowWithMinusInfix = 
             {character = Unicode 0x293C;  
              glyph = "⤼";  
              name="top arc clockwise arrow with minus";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let topCurlyBracketPostfix = 
             {character = Unicode 0x23DE;  
              glyph = "⏞";  
              name="top curly bracket";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let topParenthesisPostfix = 
             {character = Unicode 0x23DC;  
              glyph = "⏜";  
              name="top parenthesis";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let topSquareBracketPostfix = 
             {character = Unicode 0x23B4;  
              glyph = "⎴";  
              name="top square bracket";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let topTortoiseShellBracketPostfix = 
             {character = Unicode 0x23E0;  
              glyph = "⏠";  
              name="top tortoise shell bracket";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Stretchy true; Accent true]}
        let transversalIntersectionInfix = 
             {character = Unicode 0x2ADB;  
              glyph = "⫛";  
              name="transversal intersection";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let triangleWithDotAboveInfix = 
             {character = Unicode 0x29CA;  
              glyph = "⧊";  
              name="triangle with dot above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let triangleWithSerifsAtBottomInfix = 
             {character = Unicode 0x29CD;  
              glyph = "⧍";  
              name="triangle with serifs at bottom";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let triangleWithUnderbarInfix = 
             {character = Unicode 0x29CB;  
              glyph = "⧋";  
              name="triangle with underbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let tripleColonOperatorInfix = 
             {character = Unicode 0x2AF6;  
              glyph = "⫶";  
              name="triple colon operator";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let tripleHorizontalBarWithDoubleVerticalStrokeInfix = 
             {character = Unicode 0x2A68;  
              glyph = "⩨";  
              name="triple horizontal bar with double vertical stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tripleHorizontalBarWithTripleVerticalStrokeInfix = 
             {character = Unicode 0x2A69;  
              glyph = "⩩";  
              name="triple horizontal bar with triple vertical stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tripleIntegralPrefix = 
             {character = Unicode 0x222D;  
              glyph = "∭";  
              name="triple integral";  
              form = Prefix;  
              priority = 300;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let tripleNestedGreaterThanInfix = 
             {character = Unicode 0x2AF8;  
              glyph = "⫸";  
              name="triple nested greater-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tripleNestedLessThanInfix = 
             {character = Unicode 0x2AF7;  
              glyph = "⫷";  
              name="triple nested less-than";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let triplePlusInfix = 
             {character = Unicode 0x29FB;  
              glyph = "⧻";  
              name="triple plus";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let triplePrimePostfix = 
             {character = Unicode 0x2034;  
              glyph = "‴";  
              name="triple prime";  
              form = Postfix;  
              priority = 880;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Accent true]}
        let tripleSolidusBinaryRelationInfix = 
             {character = Unicode 0x2AFB;  
              glyph = "⫻";  
              name="triple solidus binary relation";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let tripleTildeInfix = 
             {character = Unicode 0x224B;  
              glyph = "≋";  
              name="triple tilde";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tripleVerticalBarBinaryRelationInfix = 
             {character = Unicode 0x2AF4;  
              glyph = "⫴";  
              name="triple vertical bar binary relation";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let tripleVerticalBarDelimiterPostfix = 
             {character = Unicode 0x2980;  
              glyph = "⦀";  
              name="triple vertical bar delimiter";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true]}
        let tripleVerticalBarDelimiterPrefix = 
             {character = Unicode 0x2980;  
              glyph = "⦀";  
              name="triple vertical bar delimiter";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true]}
        let tripleVerticalBarRightTurnstileInfix = 
             {character = Unicode 0x22AA;  
              glyph = "⊪";  
              name="triple vertical bar right turnstile";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let tripleVerticalBarWithHorizontalStrokeInfix = 
             {character = Unicode 0x2AF5;  
              glyph = "⫵";  
              name="triple vertical bar with horizontal stroke";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let trueInfix = 
             {character = Unicode 0x22A8;  
              glyph = "⊨";  
              name="TRUE";  
              form = Infix;  
              priority = 170;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let turnedAngleInfix = 
             {character = Unicode 0x29A2;  
              glyph = "⦢";  
              name="turned angle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let twoConsecutiveEqualsSignsInfix = 
             {character = Unicode 0x2A75;  
              glyph = "⩵";  
              name="two consecutive equals signs";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let twoIntersectingLogicalAndInfix = 
             {character = Unicode 0x2A55;  
              glyph = "⩕";  
              name="two intersecting logical and";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let twoIntersectingLogicalOrInfix = 
             {character = Unicode 0x2A56;  
              glyph = "⩖";  
              name="two intersecting logical or";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let twoJoinedSquaresInfix = 
             {character = Unicode 0x29C9;  
              glyph = "⧉";  
              name="two joined squares";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let twoLogicalAndOperatorPrefix = 
             {character = Unicode 0x2A07;  
              glyph = "⨇";  
              name="two logical and operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let twoLogicalOrOperatorPrefix = 
             {character = Unicode 0x2A08;  
              glyph = "⨈";  
              name="two logical or operator";  
              form = Prefix;  
              priority = 330;  
              lspace = NamedLength VeryVeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[LargeOp true; MovableLimits true; Symmetric true]}
        let unionAboveBarAboveIntersectionInfix = 
             {character = Unicode 0x2A48;  
              glyph = "⩈";  
              name="union above bar above intersection";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let unionAboveIntersectionInfix = 
             {character = Unicode 0x2A46;  
              glyph = "⩆";  
              name="union above intersection";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let unionBesideAndJoinedWithUnionInfix = 
             {character = Unicode 0x2A4A;  
              glyph = "⩊";  
              name="union beside and joined with union";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let unionInfix = 
             {character = Unicode 0x222A;  
              glyph = "∪";  
              name="union";  
              form = Infix;  
              priority = 350;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let unionWithLogicalOrInfix = 
             {character = Unicode 0x2A45;  
              glyph = "⩅";  
              name="union with logical or";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let unionWithMinusSignInfix = 
             {character = Unicode 0x2A41;  
              glyph = "⩁";  
              name="union with minus sign";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let unionWithOverbarInfix = 
             {character = Unicode 0x2A42;  
              glyph = "⩂";  
              name="union with overbar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let upArrowThroughCircleInfix = 
             {character = Unicode 0x29BD;  
              glyph = "⦽";  
              name="up arrow through circle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let upBarbLeftDownBarbLeftHarpoonInfix = 
             {character = Unicode 0x2951;  
              glyph = "⥑";  
              name="up barb left down barb left harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upBarbLeftDownBarbRightHarpoonInfix = 
             {character = Unicode 0x294D;  
              glyph = "⥍";  
              name="up barb left down barb right harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upBarbRightDownBarbLeftHarpoonInfix = 
             {character = Unicode 0x294C;  
              glyph = "⥌";  
              name="up barb right down barb left harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upBarbRightDownBarbRightHarpoonInfix = 
             {character = Unicode 0x294F;  
              glyph = "⥏";  
              name="up barb right down barb right harpoon";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upDownArrowInfix = 
             {character = Unicode 0x2195;  
              glyph = "↕";  
              name="up down arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upDownArrowWithBaseInfix = 
             {character = Unicode 0x21A8;  
              glyph = "↨";  
              name="up down arrow with base";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upDownDoubleArrowInfix = 
             {character = Unicode 0x21D5;  
              glyph = "⇕";  
              name="up down double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upDownWhiteArrowInfix = 
             {character = Unicode 0x21F3;  
              glyph = "⇳";  
              name="up down white arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upFishTailInfix = 
             {character = Unicode 0x297E;  
              glyph = "⥾";  
              name="up fish tail";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upRightDiagonalEllipsisInfix = 
             {character = Unicode 0x22F0;  
              glyph = "⋰";  
              name="up right diagonal ellipsis";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upTackInfix = 
             {character = Unicode 0x22A5;  
              glyph = "⊥";  
              name="up tack";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upwardsArrowFromBarInfix = 
             {character = Unicode 0x21A5;  
              glyph = "↥";  
              name="upwards arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsArrowInfix = 
             {character = Unicode 0x2191;  
              glyph = "↑";  
              name="upwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsArrowLeftwardsOfDownwardsArrowInfix = 
             {character = Unicode 0x21C5;  
              glyph = "⇅";  
              name="upwards arrow leftwards of downwards arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsArrowToBarInfix = 
             {character = Unicode 0x2912;  
              glyph = "⤒";  
              name="upwards arrow to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsArrowWithDoubleStrokeInfix = 
             {character = Unicode 0x21DE;  
              glyph = "⇞";  
              name="upwards arrow with double stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upwardsArrowWithHorizontalStrokeInfix = 
             {character = Unicode 0x2909;  
              glyph = "⤉";  
              name="upwards arrow with horizontal stroke";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upwardsArrowWithTipLeftwardsInfix = 
             {character = Unicode 0x21B0;  
              glyph = "↰";  
              name="upwards arrow with tip leftwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsArrowWithTipRightwardsInfix = 
             {character = Unicode 0x21B1;  
              glyph = "↱";  
              name="upwards arrow with tip rightwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsDashedArrowInfix = 
             {character = Unicode 0x21E1;  
              glyph = "⇡";  
              name="upwards dashed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsDoubleArrowInfix = 
             {character = Unicode 0x21D1;  
              glyph = "⇑";  
              name="upwards double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsHarpoonWithBarbLeftBesideDownwardsHarpoonWithBarbRightInfix = 
             {character = Unicode 0x296E;  
              glyph = "⥮";  
              name="upwards harpoon with barb left beside downwards harpoon with barb right";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsHarpoonWithBarbLeftBesideUpwardsHarpoonWithBarbRightInfix = 
             {character = Unicode 0x2963;  
              glyph = "⥣";  
              name="upwards harpoon with barb left beside upwards harpoon with barb right";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upwardsHarpoonWithBarbLeftFromBarInfix = 
             {character = Unicode 0x2960;  
              glyph = "⥠";  
              name="upwards harpoon with barb left from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsHarpoonWithBarbLeftToBarInfix = 
             {character = Unicode 0x2958;  
              glyph = "⥘";  
              name="upwards harpoon with barb left to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsHarpoonWithBarbLeftwardsInfix = 
             {character = Unicode 0x21BF;  
              glyph = "↿";  
              name="upwards harpoon with barb leftwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsHarpoonWithBarbRightFromBarInfix = 
             {character = Unicode 0x295C;  
              glyph = "⥜";  
              name="upwards harpoon with barb right from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsHarpoonWithBarbRightToBarInfix = 
             {character = Unicode 0x2954;  
              glyph = "⥔";  
              name="upwards harpoon with barb right to bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsHarpoonWithBarbRightwardsInfix = 
             {character = Unicode 0x21BE;  
              glyph = "↾";  
              name="upwards harpoon with barb rightwards";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsPairedArrowsInfix = 
             {character = Unicode 0x21C8;  
              glyph = "⇈";  
              name="upwards paired arrows";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsQuadrupleArrowInfix = 
             {character = Unicode 0x27F0;  
              glyph = "⟰";  
              name="upwards quadruple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsTripleArrowInfix = 
             {character = Unicode 0x290A;  
              glyph = "⤊";  
              name="upwards triple arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsTwoHeadedArrowFromSmallCircleInfix = 
             {character = Unicode 0x2949;  
              glyph = "⥉";  
              name="upwards two-headed arrow from small circle";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let upwardsTwoHeadedArrowInfix = 
             {character = Unicode 0x219F;  
              glyph = "↟";  
              name="upwards two headed arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true; Accent true]}
        let upwardsWhiteArrowFromBarInfix = 
             {character = Unicode 0x21EA;  
              glyph = "⇪";  
              name="upwards white arrow from bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsWhiteArrowInfix = 
             {character = Unicode 0x21E7;  
              glyph = "⇧";  
              name="upwards white arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsWhiteArrowOnPedestalInfix = 
             {character = Unicode 0x21EB;  
              glyph = "⇫";  
              name="upwards white arrow on pedestal";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsWhiteArrowOnPedestalWithHorizontalBarInfix = 
             {character = Unicode 0x21EC;  
              glyph = "⇬";  
              name="upwards white arrow on pedestal with horizontal bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsWhiteArrowOnPedestalWithVerticalBarInfix = 
             {character = Unicode 0x21ED;  
              glyph = "⇭";  
              name="upwards white arrow on pedestal with vertical bar";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsWhiteDoubleArrowInfix = 
             {character = Unicode 0x21EE;  
              glyph = "⇮";  
              name="upwards white double arrow";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let upwardsWhiteDoubleArrowOnPedestalInfix = 
             {character = Unicode 0x21EF;  
              glyph = "⇯";  
              name="upwards white double arrow on pedestal";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Stretchy true]}
        let vectorOrCrossProductInfix = 
             {character = Unicode 0x2A2F;  
              glyph = "⨯";  
              name="vector or cross product";  
              form = Infix;  
              priority = 390;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let verticalBarBesideRightTriangleInfix = 
             {character = Unicode 0x29D0;  
              glyph = "⧐";  
              name="vertical bar beside right triangle";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let verticalBarBesideRightTriangleWithSlashInfix = 
             {character = UnicodeArray [|Unicode 0x29D0;Unicode 0x0020;Unicode 0x338|];  
              glyph = "⧐̸";  
              name="vertical bar beside right triangle with slash";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let verticalBarDoubleLeftTurnstileInfix = 
             {character = Unicode 0x2AE4;  
              glyph = "⫤";  
              name="vertical bar double left turnstile";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let verticalBarTripleRightTurnstileInfix = 
             {character = Unicode 0x2AE2;  
              glyph = "⫢";  
              name="vertical bar triple right turnstile";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let verticalEllipsisInfix = 
             {character = Unicode 0x22EE;  
              glyph = "⋮";  
              name="vertical ellipsis";  
              form = Infix;  
              priority = 150;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let verticalLineInfix = 
             {character = Char  '|';  
              glyph = "|";  
              name="vertical line";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength VeryThinMathSpace;  
              rspace = NamedLength VeryThinMathSpace;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let verticalLinePostfix = 
             {character = Char  '|';  
              glyph = "|";  
              name="vertical line";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let verticalLinePrefix = 
             {character = Char  '|';  
              glyph = "|";  
              name="vertical line";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let verticalLineWithCircleAboveInfix = 
             {character = Unicode 0x2AEF;  
              glyph = "⫯";  
              name="vertical line with circle above";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let verticalLineWithCircleBelowInfix = 
             {character = Unicode 0x2AF0;  
              glyph = "⫰";  
              name="vertical line with circle below";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let verticalZigzagLineInfix = 
             {character = Unicode 0x299A;  
              glyph = "⦚";  
              name="vertical zigzag line";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let veryMuchGreaterThanInfix = 
             {character = Unicode 0x22D9;  
              glyph = "⋙";  
              name="very much greater-than";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let veryMuchLessThanInfix = 
             {character = Unicode 0x22D8;  
              glyph = "⋘";  
              name="very much less-than";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let volumeIntegralPrefix = 
             {character = Unicode 0x2230;  
              glyph = "∰";  
              name="volume integral";  
              form = Prefix;  
              priority = 310;  
              lspace= EM 0.<em>;  
              rspace = NamedLength VeryVeryThinMathSpace;  
              properties=[LargeOp true; Symmetric true]}
        let waveArrowPointingDirectlyRightInfix = 
             {character = Unicode 0x2933;  
              glyph = "⤳";  
              name="wave arrow pointing directly right";  
              form = Infix;  
              priority = 270;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[Accent true]}
        let whiteBulletInfix = 
             {character = Unicode 0x25E6;  
              glyph = "◦";  
              name="white bullet";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteCircleWithDownArrowInfix = 
             {character = Unicode 0x29EC;  
              glyph = "⧬";  
              name="white circle with down arrow";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let whiteDiamondContainingBlackSmallDiamondInfix = 
             {character = Unicode 0x25C8;  
              glyph = "◈";  
              name="white diamond containing black small diamond";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteDiamondInfix = 
             {character = Unicode 0x25C7;  
              glyph = "◇";  
              name="white diamond";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteDownPointingSmallTriangleInfix = 
             {character = Unicode 0x25BF;  
              glyph = "▿";  
              name="white down-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteDownPointingTriangleInfix = 
             {character = Unicode 0x25BD;  
              glyph = "▽";  
              name="white down-pointing triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteHourglassInfix = 
             {character = Unicode 0x29D6;  
              glyph = "⧖";  
              name="white hourglass";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteLeftPointingPointerInfix = 
             {character = Unicode 0x25C5;  
              glyph = "◅";  
              name="white left-pointing pointer";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteLeftPointingSmallTriangleInfix = 
             {character = Unicode 0x25C3;  
              glyph = "◃";  
              name="white left-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteLeftPointingTriangleInfix = 
             {character = Unicode 0x25C1;  
              glyph = "◁";  
              name="white left-pointing triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteParallelogramInfix = 
             {character = Unicode 0x25B1;  
              glyph = "▱";  
              name="white parallelogram";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let whiteRectangleInfix = 
             {character = Unicode 0x25AD;  
              glyph = "▭";  
              name="white rectangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let whiteRightPointingSmallTriangleInfix = 
             {character = Unicode 0x25B9;  
              glyph = "▹";  
              name="white right-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteRightPointingTriangleInfix = 
             {character = Unicode 0x25B7;  
              glyph = "▷";  
              name="white right-pointing triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteSmallSquareInfix = 
             {character = Unicode 0x25AB;  
              glyph = "▫";  
              name="white small square";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let whiteSquareInfix = 
             {character = Unicode 0x25A1;  
              glyph = "□";  
              name="white square";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let whiteUpPointingSmallTriangleInfix = 
             {character = Unicode 0x25B5;  
              glyph = "▵";  
              name="white up-pointing small triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteUpPointingTriangleInfix = 
             {character = Unicode 0x25B3;  
              glyph = "△";  
              name="white up-pointing triangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let whiteVerticalBarInfix = 
             {character = Unicode 0x2AFE;  
              glyph = "⫾";  
              name="white vertical bar";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let whiteVerticalRectangleInfix = 
             {character = Unicode 0x25AF;  
              glyph = "▯";  
              name="white vertical rectangle";  
              form = Infix;  
              priority = 260;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let wreathProductInfix = 
             {character = Unicode 0x2240;  
              glyph = "≀";  
              name="wreath product";  
              form = Infix;  
              priority = 340;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let xorInfix = 
             {character = Unicode 0x22BB;  
              glyph = "⊻";  
              name="xor";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let zNotationBagMembershipInfix = 
             {character = Unicode 0x22FF;  
              glyph = "⋿";  
              name="z notation bag membership";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThickMathSpace;  
              rspace = NamedLength ThickMathSpace;  
              properties=[]}
        let zNotationDomainAntirestrictionInfix = 
             {character = Unicode 0x2A64;  
              glyph = "⩤";  
              name="z notation domain antirestriction";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let zNotationLeftBindingBracketPrefix = 
             {character = Unicode 0x2989;  
              glyph = "⦉";  
              name="z notation left binding bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let zNotationLeftImageBracketPrefix = 
             {character = Unicode 0x2987;  
              glyph = "⦇";  
              name="z notation left image bracket";  
              form = Prefix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let zNotationRangeAntirestrictionInfix = 
             {character = Unicode 0x2A65;  
              glyph = "⩥";  
              name="z notation range antirestriction";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let zNotationRelationalCompositionInfix = 
             {character = Unicode 0x2A3E;  
              glyph = "⨾";  
              name="z notation relational composition";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength MediumMathSpace;  
              rspace = NamedLength MediumMathSpace;  
              properties=[]}
        let zNotationRightBindingBracketPostfix = 
             {character = Unicode 0x298A;  
              glyph = "⦊";  
              name="z notation right binding bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let zNotationRightImageBracketPostfix = 
             {character = Unicode 0x2988;  
              glyph = "⦈";  
              name="z notation right image bracket";  
              form = Postfix;  
              priority = 20;  
              lspace= EM 0.<em>;  
              rspace= EM 0.<em>;  
              properties=[Fence true; Stretchy true; Symmetric true]}
        let zNotationSchemaCompositionInfix = 
             {character = Unicode 0x2A1F;  
              glyph = "⨟";  
              name="z notation schema composition";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let zNotationSchemaPipingInfix = 
             {character = Unicode 0x2A20;  
              glyph = "⨠";  
              name="z notation schema piping";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let zNotationSchemaProjectionInfix = 
             {character = Unicode 0x2A21;  
              glyph = "⨡";  
              name="z notation schema projection";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let zNotationSpotInfix = 
             {character = Unicode 0x2981;  
              glyph = "⦁";  
              name="z notation spot";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}
        let zNotationTypeColonInfix = 
             {character = Unicode 0x2982;  
              glyph = "⦂";  
              name="z notation type colon";  
              form = Infix;  
              priority = 265;  
              lspace = NamedLength ThinMathSpace;  
              rspace = NamedLength ThinMathSpace;  
              properties=[]}